/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.filters;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import org.sonar.api.issue.Issue;
import org.sonar.api.issue.batch.IssueFilterChain;
import org.sonar.java.bytecode.visitor.ResourceMapping;
import org.sonar.java.filters.CodeVisitorIssueFilter;
import org.sonar.java.filters.EclipseI18NFilter;
import org.sonar.java.filters.JavaIssueFilter;
import org.sonar.java.filters.LombokFilter;
import org.sonar.java.filters.SuppressWarningFilter;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;

public class PostAnalysisIssueFilter
implements JavaFileScanner,
CodeVisitorIssueFilter {
    private static final Iterable<JavaIssueFilter> DEFAULT_ISSUE_FILTERS = ImmutableList.of((Object)new EclipseI18NFilter(), (Object)new LombokFilter(), (Object)new SuppressWarningFilter());
    private ResourceMapping resourceMapping;
    private Iterable<JavaIssueFilter> issueFilers;

    public void setResourceMapping(ResourceMapping resourceMapping) {
        this.resourceMapping = resourceMapping;
    }

    @VisibleForTesting
    void setIssueFilters(Iterable<? extends JavaIssueFilter> issueFilters) {
        this.issueFilers = ImmutableList.builder().addAll(issueFilters).build();
    }

    @VisibleForTesting
    Iterable<JavaIssueFilter> getIssueFilters() {
        if (this.issueFilers == null) {
            this.issueFilers = DEFAULT_ISSUE_FILTERS;
        }
        return this.issueFilers;
    }

    public boolean accept(Issue issue, IssueFilterChain chain) {
        for (JavaIssueFilter javaIssueFilter : this.getIssueFilters()) {
            if (javaIssueFilter.accept(issue)) continue;
            return false;
        }
        return chain.accept(issue);
    }

    public void scanFile(JavaFileScannerContext context) {
        String componentKey = this.resourceMapping.getComponentKeyByFileKey(context.getFileKey());
        for (JavaIssueFilter javaIssueFilter : this.getIssueFilters()) {
            javaIssueFilter.setComponentKey(componentKey);
            javaIssueFilter.scanFile(context);
        }
    }
}

