/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1610", name="Abstract classes without fields should be converted to interfaces", tags={"java8"}, priority=Priority.MAJOR)
@SqaleSubCharacteristic(value="ARCHITECTURE_CHANGEABILITY")
@SqaleConstantRemediation(value="10min")
public class AbstractClassNoFieldShouldBeInterfaceCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (AbstractClassNoFieldShouldBeInterfaceCheck.classIsAbstract(classTree) && AbstractClassNoFieldShouldBeInterfaceCheck.classHasNoField(classTree) && !AbstractClassNoFieldShouldBeInterfaceCheck.classHasProtectedMethod(classTree)) {
            this.addIssue((Tree)classTree, "Convert the abstract class \"" + classTree.simpleName().name() + "\" into an interface");
        }
    }

    private static boolean classHasProtectedMethod(ClassTree tree) {
        for (Tree member : tree.members()) {
            if (!member.is(new Tree.Kind[]{Tree.Kind.METHOD}) || !ModifiersUtils.hasModifier((ModifiersTree)((MethodTree)member).modifiers(), (Modifier)Modifier.PROTECTED)) continue;
            return true;
        }
        return false;
    }

    private static boolean classIsAbstract(ClassTree tree) {
        return ModifiersUtils.hasModifier((ModifiersTree)tree.modifiers(), (Modifier)Modifier.ABSTRACT);
    }

    private static boolean classHasNoField(ClassTree tree) {
        for (Tree member : tree.members()) {
            if (!member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) continue;
            return false;
        }
        return true;
    }
}

