/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.ArrayTypeTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1197", name="Array designators \"[]\" should be on the type, not the variable", tags={"convention"}, priority=Priority.MINOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="5min")
public class ArrayDesignatorOnVariableCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.VARIABLE);
    }

    public void visitNode(Tree tree) {
        VariableTree variableTree = (VariableTree)tree;
        TypeTree type = variableTree.type();
        SyntaxToken identifierToken = variableTree.simpleName().identifierToken();
        while (type.is(new Tree.Kind[]{Tree.Kind.ARRAY_TYPE})) {
            ArrayTypeTree arrayTypeTree = (ArrayTypeTree)type;
            SyntaxToken arrayDesignatorToken = arrayTypeTree.ellipsisToken();
            if (arrayDesignatorToken == null) {
                arrayDesignatorToken = arrayTypeTree.openBracketToken();
            }
            if (ArrayDesignatorOnVariableCheck.isInvalidPosition(arrayDesignatorToken, identifierToken)) {
                this.addIssue((Tree)arrayDesignatorToken, "Move the array designator from the variable to the type.");
                break;
            }
            type = arrayTypeTree.type();
        }
    }

    private static boolean isInvalidPosition(SyntaxToken arrayDesignatorToken, SyntaxToken identifierToken) {
        return identifierToken.line() < arrayDesignatorToken.line() || identifierToken.line() == arrayDesignatorToken.line() && identifierToken.column() < arrayDesignatorToken.column();
    }
}

