/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2387", name="Child class members should not shadow parent class members", tags={"confusing"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="DATA_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class ChildClassShadowFieldCheck
extends SubscriptionBaseVisitor {
    private static final Set<String> IGNORED_FIELDS = ImmutableSet.of((Object)"serialVersionUID");

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (classTree.superClass() != null) {
            Symbol.TypeSymbol superclassSymbol = classTree.superClass().symbolType().symbol();
            for (Tree member : classTree.members()) {
                String fieldName;
                if (!member.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) || IGNORED_FIELDS.contains(fieldName = ((VariableTree)member).simpleName().name())) continue;
                this.checkForIssue(superclassSymbol, member, fieldName);
            }
        }
    }

    private void checkForIssue(Symbol.TypeSymbol classSymbol, Tree memberTree, String fieldName) {
        Symbol.TypeSymbol symbol = classSymbol;
        while (symbol != null) {
            for (Symbol member : symbol.memberSymbols()) {
                if (!member.isVariableSymbol() || member.isPrivate()) continue;
                if (member.name().equals(fieldName)) {
                    this.addIssue(memberTree, String.format("\"%s\" is the name of a field in \"%s\".", fieldName, symbol.name()));
                    return;
                }
                if (!member.name().equalsIgnoreCase(fieldName)) continue;
                this.addIssue(memberTree, String.format("\"%s\" differs only by case from \"%s\" in \"%s\".", fieldName, member.name(), symbol.name()));
                return;
            }
            symbol = ChildClassShadowFieldCheck.getSuperclass(symbol);
        }
    }

    @CheckForNull
    private static Symbol.TypeSymbol getSuperclass(Symbol.TypeSymbol symbol) {
        Type superType = symbol.superClass();
        if (superType != null) {
            return superType.symbol();
        }
        return null;
    }
}

