/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.java.resolve.JavaType;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1698", name="Objects should be compared with \"equals()\"", tags={"cert", "cwe"}, priority=Priority.MAJOR)
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="2min")
public class CompareObjectWithEqualsCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        if (context.getSemanticModel() != null) {
            this.scan((Tree)context.getTree());
        }
    }

    public void visitMethod(MethodTree tree) {
        if (!CompareObjectWithEqualsCheck.isEquals(tree)) {
            super.visitMethod(tree);
        }
    }

    private static boolean isEquals(MethodTree tree) {
        return ((MethodTreeImpl)tree).isEqualsMethod();
    }

    public void visitBinaryExpression(BinaryExpressionTree tree) {
        Type rightOpType;
        Type leftOpType;
        super.visitBinaryExpression(tree);
        if (tree.is(new Tree.Kind[]{Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO}) && !CompareObjectWithEqualsCheck.isExcluded(leftOpType = tree.leftOperand().symbolType(), rightOpType = tree.rightOperand().symbolType()) && CompareObjectWithEqualsCheck.hasObjectOperand(leftOpType, rightOpType)) {
            this.context.addIssue((Tree)tree, (JavaCheck)this, "Change this comparison to use the equals method.");
        }
    }

    private static boolean hasObjectOperand(Type leftOpType, Type rightOpType) {
        return CompareObjectWithEqualsCheck.isObject(leftOpType) || CompareObjectWithEqualsCheck.isObject(rightOpType);
    }

    private static boolean isExcluded(Type leftOpType, Type rightOpType) {
        return CompareObjectWithEqualsCheck.isNullComparison(leftOpType, rightOpType) || CompareObjectWithEqualsCheck.isNumericalComparison(leftOpType, rightOpType) || CompareObjectWithEqualsCheck.isJavaLangClassComparison(leftOpType, rightOpType);
    }

    private static boolean isObject(Type operandType) {
        return operandType.erasure().isClass() && !operandType.symbol().isEnum();
    }

    private static boolean isNullComparison(Type leftOpType, Type rightOpType) {
        return CompareObjectWithEqualsCheck.isBot(leftOpType) || CompareObjectWithEqualsCheck.isBot(rightOpType);
    }

    private static boolean isNumericalComparison(Type leftOperandType, Type rightOperandType) {
        return leftOperandType.isNumerical() || rightOperandType.isNumerical();
    }

    private static boolean isJavaLangClassComparison(Type leftOpType, Type rightOpType) {
        return leftOpType.is("java.lang.Class") || rightOpType.is("java.lang.Class");
    }

    private static boolean isBot(Type type) {
        return ((JavaType)type).isTagged(13);
    }
}

