/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.JavaPropertiesHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.checks.methods.MethodMatcher;
import org.sonar.java.checks.methods.TypeCriteria;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2070", name="SHA-1 and Message-Digest hash algorithms should not be used", tags={"cwe", "owasp-a6", "sans-top25-porous", "security"}, priority=Priority.CRITICAL)
@SqaleSubCharacteristic(value="SECURITY_FEATURES")
@SqaleConstantRemediation(value="30min")
public class DeprecatedHashAlgorithmCheck
extends AbstractMethodDetection {
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String MD5 = "MD5";
    private static final String SHA1 = "SHA1";
    private static final Map<String, String> ALGORITHM_BY_METHOD_NAME = ImmutableMap.builder().put((Object)"getMd5Digest", (Object)"MD5").put((Object)"getShaDigest", (Object)"SHA1").put((Object)"getSha1Digest", (Object)"SHA1").put((Object)"md5", (Object)"MD5").put((Object)"md5Hex", (Object)"MD5").put((Object)"sha1", (Object)"SHA1").put((Object)"sha1Hex", (Object)"SHA1").put((Object)"sha", (Object)"SHA1").put((Object)"shaHex", (Object)"SHA1").build();

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        ImmutableList.Builder builder = ImmutableList.builder().add((Object)MethodMatcher.create().typeDefinition("java.security.MessageDigest").name("getInstance").addParameter(JAVA_LANG_STRING)).add((Object)MethodMatcher.create().typeDefinition("java.security.MessageDigest").name("getInstance").addParameter(JAVA_LANG_STRING).addParameter(TypeCriteria.anyType())).add((Object)MethodMatcher.create().typeDefinition("org.apache.commons.codec.digest.DigestUtils").name("getDigest").addParameter(JAVA_LANG_STRING));
        for (String methodName : ALGORITHM_BY_METHOD_NAME.keySet()) {
            builder.add((Object)MethodMatcher.create().typeDefinition("org.apache.commons.codec.digest.DigestUtils").name(methodName).withNoParameterConstraint());
        }
        for (String methodName : ImmutableList.of((Object)"md5", (Object)"sha1")) {
            builder.add((Object)MethodMatcher.create().typeDefinition("com.google.common.hash.Hashing").name(methodName));
        }
        return builder.build();
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        String methodName = DeprecatedHashAlgorithmCheck.methodName(mit);
        String algorithm = ALGORITHM_BY_METHOD_NAME.get(methodName);
        if (algorithm == null) {
            algorithm = DeprecatedHashAlgorithmCheck.algorithm((ExpressionTree)mit.arguments().get(0));
        }
        boolean isMd5 = MD5.equalsIgnoreCase(algorithm);
        boolean isSha1 = SHA1.equalsIgnoreCase(algorithm);
        if (isMd5 || isSha1) {
            String msgAlgo = isSha1 ? "SHA-1" : algorithm;
            this.addIssue((Tree)mit, "Use a stronger encryption algorithm than " + msgAlgo + ".");
        }
    }

    private static String methodName(MethodInvocationTree mit) {
        String name = null;
        ExpressionTree methodSelect = mit.methodSelect();
        if (methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            name = ((MemberSelectExpressionTree)methodSelect).identifier().name();
        } else if (methodSelect.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            name = ((IdentifierTree)methodSelect).name();
        }
        return name;
    }

    private static String algorithm(ExpressionTree invocationArgument) {
        ExpressionTree expectedAlgorithm = invocationArgument;
        ExpressionTree defaultPropertyValue = JavaPropertiesHelper.retrievedPropertyDefaultValue(invocationArgument);
        if (defaultPropertyValue != null) {
            expectedAlgorithm = defaultPropertyValue;
        }
        if (expectedAlgorithm.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            String algo = LiteralUtils.trimQuotes((String)((LiteralTree)expectedAlgorithm).value());
            return algo.replaceAll("-", "");
        }
        return null;
    }
}

