/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.resolve.JavaType;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1640", name="Maps with keys that are enum values should be replaced with EnumMap", tags={"performance"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="CPU_EFFICIENCY")
@SqaleConstantRemediation(value="5min")
public class EnumMapCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitVariable(VariableTree tree) {
        if (tree.type().symbolType().isSubtypeOf("java.util.Map")) {
            ExpressionTree initializer = tree.initializer();
            if (initializer != null) {
                this.checkNewMap((Tree)tree, initializer, EnumMapCheck.hasEnumKey(tree.type().symbolType()));
            }
        } else {
            super.visitVariable(tree);
        }
    }

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        if (tree.variable().symbolType().isSubtypeOf("java.util.Map")) {
            this.checkNewMap((Tree)tree, tree.expression(), EnumMapCheck.hasEnumKey(tree.variable().symbolType()));
        } else {
            super.visitAssignmentExpression(tree);
        }
    }

    public void visitNewClass(NewClassTree tree) {
        if (tree.symbolType().isSubtypeOf("java.util.HashMap") && EnumMapCheck.hasEnumKey(tree.identifier().symbolType())) {
            this.addIssue((Tree)tree);
        } else {
            super.visitNewClass(tree);
        }
    }

    private void checkNewMap(Tree tree, ExpressionTree given, boolean useEnumKey) {
        NewClassTree newClassTree;
        ExpressionTree expression = ExpressionsHelper.skipParentheses(given);
        if (expression.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS}) && (newClassTree = (NewClassTree)expression).symbolType().isSubtypeOf("java.util.HashMap") && (useEnumKey || EnumMapCheck.hasEnumKey(newClassTree.identifier().symbolType()))) {
            this.addIssue(tree);
        }
    }

    private static boolean hasEnumKey(Type type) {
        JavaType.ParametrizedTypeJavaType parametrizedTypeJavaType;
        List typeParameters;
        if (type instanceof JavaType.ParametrizedTypeJavaType && !(typeParameters = (parametrizedTypeJavaType = (JavaType.ParametrizedTypeJavaType)type).typeParameters()).isEmpty()) {
            return parametrizedTypeJavaType.substitution((JavaType.TypeVariableJavaType)typeParameters.get(0)).symbol().isEnum();
        }
        return false;
    }

    private void addIssue(Tree typeTree) {
        this.context.addIssue(typeTree, (JavaCheck)this, "Convert this Map to an EnumMap.");
    }
}

