/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2165", name="\"finalize\" should not set fields to \"null\"", tags={"clumsy", "performance"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="CPU_EFFICIENCY")
@SqaleConstantRemediation(value="5min")
public class FinalizeFieldsSetCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (this.hasSemantic() && FinalizeFieldsSetCheck.isFinalizeDeclaration(methodTree)) {
            methodTree.accept((TreeVisitor)new AssignmentVisitor());
        }
    }

    private static boolean isFinalizeDeclaration(MethodTree tree) {
        return FinalizeFieldsSetCheck.isMethodNamedFinalize(tree) && FinalizeFieldsSetCheck.hasNoParameters(tree);
    }

    private static boolean isMethodNamedFinalize(MethodTree tree) {
        return "finalize".equals(tree.simpleName().name());
    }

    private static boolean hasNoParameters(MethodTree tree) {
        return tree.parameters().isEmpty();
    }

    private class AssignmentVisitor
    extends BaseTreeVisitor {
        private AssignmentVisitor() {
        }

        public void visitClass(ClassTree tree) {
        }

        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            if (this.isFieldAssignment(tree) && this.isNullAssignment(tree)) {
                FinalizeFieldsSetCheck.this.addIssue((Tree)tree, "Remove this nullification of \"" + this.getFieldName(tree) + "\".");
            }
        }

        private boolean isFieldAssignment(AssignmentExpressionTree tree) {
            ExpressionTree variable = tree.variable();
            if (variable.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                MemberSelectExpressionTree memberSelectExpressionTree = (MemberSelectExpressionTree)variable;
                if (!this.isThis(memberSelectExpressionTree.expression())) {
                    return false;
                }
                variable = memberSelectExpressionTree.identifier();
            }
            if (variable.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                Symbol variableSymbol = ((IdentifierTree)variable).symbol();
                return variableSymbol.owner().isTypeSymbol();
            }
            return false;
        }

        private boolean isThis(ExpressionTree tree) {
            return tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && "this".equals(((IdentifierTree)tree).name());
        }

        private boolean isNullAssignment(AssignmentExpressionTree tree) {
            return tree.expression().is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL});
        }

        private String getFieldName(AssignmentExpressionTree tree) {
            ExpressionTree variable = tree.variable();
            if (variable.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                variable = ((MemberSelectExpressionTree)variable).identifier();
            }
            return ((IdentifierTree)variable).name();
        }
    }
}

