/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.base.Splitter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1313", name="IP addresses should not be hardcoded", tags={"cert", "security"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="ARCHITECTURE_CHANGEABILITY")
@SqaleConstantRemediation(value="30min")
public class HardcodedIpCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final Matcher IP = Pattern.compile("[^\\d.]*?((?:\\d{1,3}\\.){3}\\d{1,3}(?!\\d|\\.)).*?").matcher("");
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitLiteral(LiteralTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            IP.reset(tree.value());
            if (IP.matches()) {
                String ip = IP.group(1);
                if (HardcodedIpCheck.areAllBelow256(Splitter.on((char)'.').split((CharSequence)ip))) {
                    this.context.addIssue((Tree)tree, (JavaCheck)this, "Make this IP \"" + ip + "\" address configurable.");
                }
            }
        }
    }

    private static boolean areAllBelow256(Iterable<String> numbersAsStrings) {
        for (String numberAsString : numbersAsStrings) {
            if (Integer.valueOf(numberAsString) <= 255) continue;
            return false;
        }
        return true;
    }
}

