/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.SyntacticEquivalence;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1764", name="Identical expressions should not be used on both sides of a binary operator", tags={"bug", "cert"}, priority=Priority.CRITICAL)
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="2min")
public class IdenticalOperandOnBinaryExpressionCheck
extends SubscriptionBaseVisitor {
    private static final List<Tree.Kind> SYMETRIC_OPERATORS = ImmutableList.builder().add((Object)Tree.Kind.EQUAL_TO).add((Object)Tree.Kind.NOT_EQUAL_TO).add((Object)Tree.Kind.AND).add((Object)Tree.Kind.XOR).add((Object)Tree.Kind.OR).add((Object)Tree.Kind.CONDITIONAL_AND).add((Object)Tree.Kind.CONDITIONAL_OR).build();

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.builder().add((Object)Tree.Kind.DIVIDE).add((Object)Tree.Kind.REMAINDER).add((Object)Tree.Kind.MINUS).add((Object)Tree.Kind.LEFT_SHIFT).add((Object)Tree.Kind.RIGHT_SHIFT).add((Object)Tree.Kind.UNSIGNED_RIGHT_SHIFT).add((Object)Tree.Kind.LESS_THAN).add((Object)Tree.Kind.GREATER_THAN).add((Object)Tree.Kind.LESS_THAN_OR_EQUAL_TO).add((Object)Tree.Kind.GREATER_THAN_OR_EQUAL_TO).add((Object)Tree.Kind.EQUAL_TO).add((Object)Tree.Kind.NOT_EQUAL_TO).add((Object)Tree.Kind.AND).add((Object)Tree.Kind.XOR).add((Object)Tree.Kind.OR).add((Object)Tree.Kind.CONDITIONAL_AND).add((Object)Tree.Kind.CONDITIONAL_OR).build();
    }

    public void visitNode(Tree tree) {
        BinaryExpressionTree binaryExpressionTree = (BinaryExpressionTree)tree;
        if (IdenticalOperandOnBinaryExpressionCheck.hasEquivalentOperand(binaryExpressionTree)) {
            this.addIssue((Tree)binaryExpressionTree.rightOperand(), "Identical sub-expressions on both sides of operator \"" + binaryExpressionTree.operatorToken().text() + "\"");
        }
    }

    public static boolean hasEquivalentOperand(BinaryExpressionTree tree) {
        if (IdenticalOperandOnBinaryExpressionCheck.isNanTest(tree) || IdenticalOperandOnBinaryExpressionCheck.isLeftShiftOnOne(tree)) {
            return false;
        }
        Tree.Kind binaryKind = tree.kind();
        return IdenticalOperandOnBinaryExpressionCheck.areOperandEquivalent(tree.leftOperand(), tree.rightOperand(), binaryKind);
    }

    public static boolean areOperandEquivalent(ExpressionTree left, ExpressionTree right, Tree.Kind binaryKind) {
        if (SyntacticEquivalence.areEquivalent((Tree)left, (Tree)right)) {
            return true;
        }
        if (SYMETRIC_OPERATORS.contains(binaryKind) && left.is(new Tree.Kind[]{binaryKind})) {
            return IdenticalOperandOnBinaryExpressionCheck.areOperandEquivalent(((BinaryExpressionTree)left).leftOperand(), right, binaryKind) || IdenticalOperandOnBinaryExpressionCheck.areOperandEquivalent(((BinaryExpressionTree)left).rightOperand(), right, binaryKind);
        }
        return false;
    }

    private static boolean isNanTest(BinaryExpressionTree tree) {
        Type leftOperandType = tree.leftOperand().symbolType();
        return tree.is(new Tree.Kind[]{Tree.Kind.NOT_EQUAL_TO}) && (leftOperandType.isPrimitive(Type.Primitives.FLOAT) || leftOperandType.isPrimitive(Type.Primitives.DOUBLE));
    }

    private static boolean isLeftShiftOnOne(BinaryExpressionTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.LEFT_SHIFT}) && tree.leftOperand().is(new Tree.Kind[]{Tree.Kind.INT_LITERAL}) && tree.rightOperand().is(new Tree.Kind[]{Tree.Kind.INT_LITERAL})) {
            String left = ((LiteralTree)tree.leftOperand()).value();
            String right = ((LiteralTree)tree.rightOperand()).value();
            if ("1".equals(right) && "1".equals(left)) {
                return true;
            }
        }
        return false;
    }
}

