/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.LeftCurlyBraceBaseTreeVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="LeftCurlyBraceStartLineCheck", name="An open curly brace should be located at the beginning of a line", tags={"convention"}, priority=Priority.MINOR)
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="1min")
public class LeftCurlyBraceStartLineCheck
extends LeftCurlyBraceBaseTreeVisitor {
    @Override
    protected void checkTokens(SyntaxToken lastToken, SyntaxToken openBraceToken) {
        if (lastToken.line() == openBraceToken.line()) {
            this.addIssue(openBraceToken, (JavaCheck)this, "Move this left curly brace to the beginning of next line of code.");
        }
    }
}

