/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1695", name="\"NullPointerException\" should not be explicitly thrown", tags={"pitfall"}, priority=Priority.MAJOR)
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="10min")
public class NPEThrowCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.THROW_STATEMENT, (Object)Tree.Kind.METHOD, (Object)Tree.Kind.CONSTRUCTOR);
    }

    public void visitNode(Tree tree) {
        if (this.hasSemantic()) {
            if (tree.is(new Tree.Kind[]{Tree.Kind.THROW_STATEMENT})) {
                ExpressionTree expressionTree = ((ThrowStatementTree)tree).expression();
                this.raiseIssueOnNpe((Tree)expressionTree, expressionTree.symbolType());
            } else {
                for (TypeTree throwClause : ((MethodTree)tree).throwsClauses()) {
                    this.raiseIssueOnNpe((Tree)throwClause, throwClause.symbolType());
                }
            }
        }
    }

    private void raiseIssueOnNpe(Tree tree, Type type) {
        if (type.is("java.lang.NullPointerException")) {
            this.addIssue(NPEThrowCheck.treeAtFault(tree), "Throw some other exception here, such as \"IllegalArgumentException\".");
        }
    }

    private static Tree treeAtFault(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS}) ? ((NewClassTree)tree).identifier() : tree;
    }
}

