/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.AbstractInjectionChecker;
import org.sonar.java.checks.methods.MethodMatcher;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2076", name="Values passed to OS commands should be sanitized", tags={"cwe", "owasp-a1", "sans-top25-insecure", "security"}, priority=Priority.CRITICAL)
@SqaleSubCharacteristic(value="INPUT_VALIDATION_AND_REPRESENTATION")
@SqaleConstantRemediation(value="30min")
public class OSCommandInjectionCheck
extends AbstractInjectionChecker {
    private static final MethodMatcher RUNTIME_EXEC_MATCHER = MethodMatcher.create().typeDefinition("java.lang.Runtime").name("exec").withNoParameterConstraint();
    private static final MethodMatcher PROCESS_BUILDER_COMMAND_MATCHER = MethodMatcher.create().typeDefinition("java.lang.ProcessBuilder").name("command").withNoParameterConstraint();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD_INVOCATION, (Object)Tree.Kind.NEW_CLASS);
    }

    public void visitNode(Tree tree) {
        if (this.hasSemantic()) {
            if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                MethodInvocationTree mit = (MethodInvocationTree)tree;
                Arguments arguments = mit.arguments();
                if (RUNTIME_EXEC_MATCHER.matches(mit)) {
                    this.checkForIssue(tree, (ExpressionTree)arguments.get(0));
                } else if (PROCESS_BUILDER_COMMAND_MATCHER.matches(mit) && !arguments.isEmpty()) {
                    this.checkForIssue(tree, arguments);
                }
            } else if (((NewClassTree)tree).symbolType().is("java.lang.ProcessBuilder")) {
                this.checkForIssue(tree, ((NewClassTree)tree).arguments());
            }
        }
    }

    private void checkForIssue(Tree tree, Arguments arguments) {
        for (ExpressionTree arg : arguments) {
            this.checkForIssue(tree, arg);
        }
    }

    private void checkForIssue(Tree tree, ExpressionTree arg) {
        if (this.isDynamicArray(arg, tree) && !arg.symbolType().isSubtypeOf("java.util.List")) {
            this.addIssue((Tree)arg, "Make sure \"" + this.parameterName + "\" is properly sanitized before use in this OS command.");
        }
    }

    private boolean isDynamicArray(ExpressionTree arg, Tree mit) {
        if (arg.is(new Tree.Kind[]{Tree.Kind.NEW_ARRAY})) {
            NewArrayTree nat = (NewArrayTree)arg;
            for (ExpressionTree expressionTree : nat.initializers()) {
                if (!this.isDynamicString(mit, expressionTree, null)) continue;
                return true;
            }
            return false;
        }
        this.setParameterNameFromArgument(arg);
        boolean argIsString = arg.symbolType().is("java.lang.String");
        return !argIsString || this.isDynamicString(mit, arg, null);
    }
}

