/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.checks.methods.MethodMatcher;
import org.sonar.java.checks.methods.NameCriteria;
import org.sonar.java.checks.methods.TypeCriteria;
import org.sonar.java.model.LiteralUtils;
import org.sonar.java.syntaxtoken.FirstSyntaxTokenFinder;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2695", name="\"PreparedStatement\" and \"ResultSet\" methods should be called with valid indices", tags={"bug", "sql"}, priority=Priority.BLOCKER)
@ActivatedByDefault
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="2min")
public class PreparedStatementAndResultSetCheck
extends AbstractMethodDetection {
    private static final String INT = "int";
    private static final String JAVA_SQL_RESULTSET = "java.sql.ResultSet";
    private Multimap<Symbol, Tree> reassignmentBySymbol;

    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)MethodMatcher.create().typeDefinition("java.sql.PreparedStatement").name(NameCriteria.startsWith("set")).addParameter(INT).addParameter(TypeCriteria.anyType()), (Object)MethodMatcher.create().typeDefinition(JAVA_SQL_RESULTSET).name(NameCriteria.startsWith("get")).addParameter(INT), (Object)MethodMatcher.create().typeDefinition(JAVA_SQL_RESULTSET).name(NameCriteria.startsWith("get")).addParameter(INT).addParameter(TypeCriteria.anyType()));
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        Integer methodFirstArgumentAsInteger = LiteralUtils.intLiteralValue((ExpressionTree)((ExpressionTree)mit.arguments().get(0)));
        if (methodFirstArgumentAsInteger == null) {
            return;
        }
        boolean isMethodFromJavaSqlResultSet = mit.symbol().owner().type().is(JAVA_SQL_RESULTSET);
        int methodFirstArgumentValue = methodFirstArgumentAsInteger;
        if (isMethodFromJavaSqlResultSet && methodFirstArgumentValue == 0) {
            this.addIssue((Tree)mit, "ResultSet indices start at 1.");
        } else if (!isMethodFromJavaSqlResultSet) {
            if (methodFirstArgumentValue == 0) {
                this.addIssue((Tree)mit, "PreparedStatement indices start at 1.");
            } else {
                Tree preparedStatementReference = this.getPreparedStatementReference(mit);
                Integer numberParameters = this.getPreparedStatementNumberOfParameters(preparedStatementReference);
                if (numberParameters != null && methodFirstArgumentValue > numberParameters) {
                    this.addIssue((Tree)mit, "This \"PreparedStatement\" " + (numberParameters == 0 ? "has no" : "only has " + numberParameters) + " parameters.");
                }
            }
        }
    }

    @CheckForNull
    private Tree getPreparedStatementReference(MethodInvocationTree mit) {
        ExpressionTree methodSelect = mit.methodSelect();
        if (methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            ExpressionTree expression = ((MemberSelectExpressionTree)methodSelect).expression();
            if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                Symbol referenceSymbol = ((IdentifierTree)expression).symbol();
                return this.getReassignmentOrDeclaration((Tree)mit, referenceSymbol);
            }
        }
        return null;
    }

    private Tree getReassignmentOrDeclaration(Tree startingPoint, Symbol referenceSymbol) {
        int line;
        Tree lastReassignment;
        Tree result = referenceSymbol.declaration();
        List usages = referenceSymbol.usages();
        if (usages.size() == 1) {
            return result;
        }
        if (!this.reassignmentBySymbol.containsKey((Object)referenceSymbol)) {
            this.reassignmentBySymbol.putAll((Object)referenceSymbol, this.getReassignments(referenceSymbol.owner().declaration(), usages));
        }
        if ((lastReassignment = this.getLastReassignment(line = FirstSyntaxTokenFinder.firstSyntaxToken((Tree)startingPoint).line(), referenceSymbol)) != null) {
            return lastReassignment;
        }
        return result;
    }

    @CheckForNull
    private Tree getLastReassignment(int line, Symbol referenceSymbol) {
        Tree result = null;
        for (Tree reassignment : this.reassignmentBySymbol.get((Object)referenceSymbol)) {
            int reassignmentLine = FirstSyntaxTokenFinder.firstSyntaxToken((Tree)reassignment).line();
            if (line <= reassignmentLine) continue;
            result = reassignment;
        }
        return result;
    }

    private List<Tree> getReassignments(@Nullable Tree ownerDeclaration, List<IdentifierTree> usages) {
        if (ownerDeclaration != null) {
            ReassignmentFinder reassignmentFinder = new ReassignmentFinder(usages);
            ownerDeclaration.accept((TreeVisitor)reassignmentFinder);
            return reassignmentFinder.reassignments;
        }
        return new ArrayList<Tree>();
    }

    @CheckForNull
    private Integer getPreparedStatementNumberOfParameters(@Nullable Tree tree) {
        if (tree != null) {
            Arguments arguments;
            ExpressionTree initializer;
            ExpressionTree expressionTree = initializer = tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) ? ((VariableTree)tree).initializer() : ((AssignmentExpressionTree)tree).expression();
            if (initializer != null && initializer.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && !(arguments = ((MethodInvocationTree)initializer).arguments()).isEmpty()) {
                return this.getNumberQuery((ExpressionTree)arguments.get(0));
            }
        }
        return null;
    }

    @CheckForNull
    private Integer getNumberQuery(ExpressionTree expression) {
        ExpressionTree expr = ExpressionsHelper.skipParentheses(expression);
        if (expr.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            Symbol variableSymbol = ((IdentifierTree)expression).symbol();
            Tree lastAssignment = this.getReassignmentOrDeclaration((Tree)expression, variableSymbol);
            ExpressionTree initializer = lastAssignment.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) ? ((VariableTree)lastAssignment).initializer() : ((AssignmentExpressionTree)lastAssignment).expression();
            return initializer != null ? this.getNumberQuery(initializer) : null;
        }
        if (expr.is(new Tree.Kind[]{Tree.Kind.PLUS})) {
            BinaryExpressionTree stringConcatenation = (BinaryExpressionTree)expr;
            Integer left = this.getNumberQuery(stringConcatenation.leftOperand());
            Integer right = this.getNumberQuery(stringConcatenation.rightOperand());
            return left == null && right == null ? null : Integer.valueOf(PreparedStatementAndResultSetCheck.zeroIfNull(left) + PreparedStatementAndResultSetCheck.zeroIfNull(right));
        }
        return PreparedStatementAndResultSetCheck.countQuery(expr);
    }

    private static int zeroIfNull(@Nullable Integer intValue) {
        return intValue == null ? 0 : intValue;
    }

    @CheckForNull
    private static Integer countQuery(ExpressionTree expression) {
        return expression.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) ? Integer.valueOf(StringUtils.countMatches((String)((LiteralTree)expression).value(), (String)"?")) : null;
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.reassignmentBySymbol = LinkedListMultimap.create();
        super.scanFile(context);
        this.reassignmentBySymbol.clear();
    }

    private static class ReassignmentFinder
    extends BaseTreeVisitor {
        private final List<IdentifierTree> usages;
        private List<Tree> reassignments;

        public ReassignmentFinder(List<IdentifierTree> usages) {
            this.usages = usages;
            this.reassignments = new LinkedList<Tree>();
        }

        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            if (this.isSearchedVariable(tree.variable())) {
                this.reassignments.add((Tree)tree);
            }
            super.visitAssignmentExpression(tree);
        }

        private boolean isSearchedVariable(ExpressionTree variable) {
            return variable.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && this.usages.contains(variable);
        }
    }
}

