/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2055", name="The non-serializable super class of a \"Serializable\" class should have a no-argument constructor", tags={"bug", "serialization"}, priority=Priority.CRITICAL)
@ActivatedByDefault
@SqaleSubCharacteristic(value="DATA_RELIABILITY")
@SqaleConstantRemediation(value="30min")
public class SerializableSuperConstructorCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        if (this.hasSemantic()) {
            Symbol.TypeSymbol classSymbol = ((ClassTree)tree).symbol();
            Type superclass = classSymbol.superClass();
            if (SerializableSuperConstructorCheck.isSerializable(classSymbol.type()) && SerializableSuperConstructorCheck.isNotSerializableMissingNoArgConstructor(superclass)) {
                this.addIssue(tree, "Add a no-arg constructor to \"" + superclass + "\".");
            }
        }
    }

    private static boolean isNotSerializableMissingNoArgConstructor(@Nullable Type superclass) {
        return superclass != null && !SerializableSuperConstructorCheck.isSerializable(superclass) && !SerializableSuperConstructorCheck.hasNonPrivateNoArgConstructor(superclass);
    }

    private static boolean isSerializable(Type type) {
        return type.isSubtypeOf("java.io.Serializable");
    }

    private static boolean hasNonPrivateNoArgConstructor(Type type) {
        Collection constructors = type.symbol().lookupSymbols("<init>");
        for (Symbol member : constructors) {
            Symbol.MethodSymbol method;
            if (!member.isMethodSymbol() || !(method = (Symbol.MethodSymbol)member).parameterTypes().isEmpty() || method.isPrivate()) continue;
            return true;
        }
        return constructors.isEmpty();
    }
}

