/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2437", name="Silly bit operations should not be performed", tags={"bug"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class SillyBitOperationCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.XOR, (Object)Tree.Kind.XOR_ASSIGNMENT, (Object)Tree.Kind.AND, (Object)Tree.Kind.AND_ASSIGNMENT, (Object)Tree.Kind.OR, (Object)Tree.Kind.OR_ASSIGNMENT);
    }

    public void visitNode(Tree tree) {
        Long identityElement = SillyBitOperationCheck.getBitwiseOperationIdentityElement(tree);
        Long evaluatedExpression = LiteralUtils.longLiteralValue((ExpressionTree)SillyBitOperationCheck.getExpression(tree));
        if (evaluatedExpression != null && identityElement.equals(evaluatedExpression)) {
            this.addIssue(tree, "Remove this silly bit operation.");
        }
    }

    private static Long getBitwiseOperationIdentityElement(Tree tree) {
        Long identityElement = 0L;
        if (tree.is(new Tree.Kind[]{Tree.Kind.AND, Tree.Kind.AND_ASSIGNMENT})) {
            identityElement = -1L;
        }
        return identityElement;
    }

    private static ExpressionTree getExpression(Tree tree) {
        ExpressionTree expression = tree.is(new Tree.Kind[]{Tree.Kind.OR, Tree.Kind.XOR, Tree.Kind.AND}) ? ((BinaryExpressionTree)tree).rightOperand() : ((AssignmentExpressionTree)tree).expression();
        return expression;
    }
}

