/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2167", name="\"compareTo\" should not return \"Integer.MIN_VALUE\"", priority=Priority.CRITICAL, tags={"bug"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class CompareToReturnValueCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (this.hasSemantic() && CompareToReturnValueCheck.isCompareToDeclaration(methodTree)) {
            methodTree.accept((TreeVisitor)new ReturnStatementVisitor());
        }
    }

    private static boolean isCompareToDeclaration(MethodTree tree) {
        return CompareToReturnValueCheck.isNamedCompareTo(tree) && CompareToReturnValueCheck.hasOneNonPrimitiveParameter(tree) && CompareToReturnValueCheck.returnsInt(tree);
    }

    private static boolean isNamedCompareTo(MethodTree tree) {
        return "compareTo".equals(tree.simpleName().name());
    }

    private static boolean hasOneNonPrimitiveParameter(MethodTree methodTree) {
        List parameters = methodTree.parameters();
        return parameters.size() == 1 && !((VariableTree)parameters.get(0)).type().symbolType().isPrimitive();
    }

    private static boolean returnsInt(MethodTree methodTree) {
        TypeTree typeTree = methodTree.returnType();
        return typeTree != null && typeTree.symbolType().isPrimitive(Type.Primitives.INT);
    }

    private class ReturnStatementVisitor
    extends BaseTreeVisitor {
        private ReturnStatementVisitor() {
        }

        public void visitReturnStatement(ReturnStatementTree tree) {
            if (this.returnsIntegerMinValue(tree.expression())) {
                CompareToReturnValueCheck.this.addIssue((Tree)tree, "Simply return -1");
            }
        }

        private boolean returnsIntegerMinValue(ExpressionTree expressionTree) {
            if (expressionTree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                MemberSelectExpressionTree memberSelect = (MemberSelectExpressionTree)expressionTree;
                boolean isInteger = memberSelect.expression().symbolType().is("java.lang.Integer");
                boolean isMinValue = "MIN_VALUE".equals(memberSelect.identifier().name());
                return isInteger && isMinValue;
            }
            return false;
        }

        public void visitClass(ClassTree tree) {
        }
    }
}

