/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1170", name="Public constants and fields initialized at declaration should be \"static final\" rather than merely \"final\"", priority=Priority.MINOR, tags={"convention"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="MEMORY_EFFICIENCY")
@SqaleConstantRemediation(value="2min")
public class ConstantsShouldBeStaticFinalCheck
extends SubscriptionBaseVisitor {
    private int nestedClassesLevel;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.nestedClassesLevel = 0;
        super.scanFile(context);
    }

    public void visitNode(Tree tree) {
        ++this.nestedClassesLevel;
        for (Tree member : ((ClassTree)tree).members()) {
            VariableTree variableTree;
            if (!member.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) || !ConstantsShouldBeStaticFinalCheck.staticNonFinal(variableTree = (VariableTree)member) || !ConstantsShouldBeStaticFinalCheck.hasConstantInitializer(variableTree) || this.isObjectInInnerClass(variableTree)) continue;
            this.addIssue((Tree)variableTree, "Make this final field static too.");
        }
    }

    private boolean isObjectInInnerClass(VariableTree variableTree) {
        if (this.nestedClassesLevel > 1) {
            if (variableTree.type().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                return !"String".equals(((IdentifierTree)variableTree.type()).name());
            }
            return !variableTree.type().is(new Tree.Kind[]{Tree.Kind.PRIMITIVE_TYPE});
        }
        return false;
    }

    private static boolean staticNonFinal(VariableTree variableTree) {
        return ConstantsShouldBeStaticFinalCheck.isFinal(variableTree) && !ConstantsShouldBeStaticFinalCheck.isStatic(variableTree);
    }

    public void leaveNode(Tree tree) {
        --this.nestedClassesLevel;
    }

    private static boolean hasConstantInitializer(VariableTree variableTree) {
        ExpressionTree init = variableTree.initializer();
        if (init != null) {
            if (init.is(new Tree.Kind[]{Tree.Kind.NEW_ARRAY})) {
                NewArrayTree newArrayTree = (NewArrayTree)init;
                return newArrayTree.dimensions().isEmpty() || newArrayTree.openBraceToken() != null;
            }
            return !ConstantsShouldBeStaticFinalCheck.containsChildrenOfKind((JavaTree)init, Tree.Kind.METHOD_INVOCATION, Tree.Kind.NEW_CLASS);
        }
        return false;
    }

    private static boolean containsChildrenOfKind(JavaTree tree, Tree.Kind ... kinds) {
        if (Arrays.asList(kinds).contains(tree.kind())) {
            return true;
        }
        if (!tree.isLeaf()) {
            Iterator treeIterator = tree.childrenIterator();
            while (treeIterator.hasNext()) {
                JavaTree javaTree = (JavaTree)treeIterator.next();
                if (javaTree == null || !ConstantsShouldBeStaticFinalCheck.containsChildrenOfKind(javaTree, kinds)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isFinal(VariableTree variableTree) {
        return ModifiersUtils.hasModifier((ModifiersTree)variableTree.modifiers(), (Modifier)Modifier.FINAL);
    }

    private static boolean isStatic(VariableTree variableTree) {
        return ModifiersUtils.hasModifier((ModifiersTree)variableTree.modifiers(), (Modifier)Modifier.STATIC);
    }
}

