/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.SyntacticEquivalence;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1244", name="Floating point numbers should not be tested for equality", priority=Priority.CRITICAL, tags={"bug", "misra"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class FloatEqualityCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.EQUAL_TO, (Object)Tree.Kind.NOT_EQUAL_TO, (Object)Tree.Kind.CONDITIONAL_AND, (Object)Tree.Kind.CONDITIONAL_OR);
    }

    public void visitNode(Tree tree) {
        BinaryExpressionTree binaryExpressionTree = (BinaryExpressionTree)tree;
        if (binaryExpressionTree.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR}) && FloatEqualityCheck.isIndirectEquality(binaryExpressionTree)) {
            binaryExpressionTree = (BinaryExpressionTree)binaryExpressionTree.leftOperand();
        }
        if ((FloatEqualityCheck.hasFloatingType(binaryExpressionTree.leftOperand()) || FloatEqualityCheck.hasFloatingType(binaryExpressionTree.rightOperand())) && !FloatEqualityCheck.isNanTest(binaryExpressionTree)) {
            this.addIssue((Tree)binaryExpressionTree, "Equality tests should not be made with floating point values.");
        }
    }

    private static boolean isIndirectEquality(BinaryExpressionTree binaryExpressionTree) {
        return FloatEqualityCheck.isIndirectEquality(binaryExpressionTree, Tree.Kind.CONDITIONAL_AND, Tree.Kind.GREATER_THAN_OR_EQUAL_TO, Tree.Kind.LESS_THAN_OR_EQUAL_TO) || FloatEqualityCheck.isIndirectEquality(binaryExpressionTree, Tree.Kind.CONDITIONAL_OR, Tree.Kind.GREATER_THAN, Tree.Kind.LESS_THAN);
    }

    private static boolean isIndirectEquality(BinaryExpressionTree binaryExpressionTree, Tree.Kind indirectOperator, Tree.Kind comparator1, Tree.Kind comparator2) {
        if (binaryExpressionTree.is(new Tree.Kind[]{indirectOperator}) && binaryExpressionTree.leftOperand().is(new Tree.Kind[]{comparator1, comparator2})) {
            BinaryExpressionTree leftOp = (BinaryExpressionTree)binaryExpressionTree.leftOperand();
            if (binaryExpressionTree.rightOperand().is(new Tree.Kind[]{comparator1, comparator2})) {
                BinaryExpressionTree rightOp = (BinaryExpressionTree)binaryExpressionTree.rightOperand();
                if (leftOp.kind().equals((Object)rightOp.kind())) {
                    return SyntacticEquivalence.areEquivalent((Tree)leftOp.leftOperand(), (Tree)rightOp.rightOperand()) && SyntacticEquivalence.areEquivalent((Tree)leftOp.rightOperand(), (Tree)rightOp.leftOperand());
                }
                return SyntacticEquivalence.areEquivalent((Tree)leftOp.leftOperand(), (Tree)rightOp.leftOperand()) && SyntacticEquivalence.areEquivalent((Tree)leftOp.rightOperand(), (Tree)rightOp.rightOperand());
            }
        }
        return false;
    }

    private static boolean isNanTest(BinaryExpressionTree binaryExpressionTree) {
        return SyntacticEquivalence.areEquivalent((Tree)binaryExpressionTree.leftOperand(), (Tree)binaryExpressionTree.rightOperand());
    }

    private static boolean hasFloatingType(ExpressionTree expressionTree) {
        return expressionTree.symbolType().isPrimitive(Type.Primitives.FLOAT) || expressionTree.symbolType().isPrimitive(Type.Primitives.DOUBLE);
    }
}

