/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.model.SyntacticEquivalence;
import org.sonar.java.syntaxtoken.FirstSyntaxTokenFinder;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.CaseLabelTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1871", name="Two branches in the same conditional structure should not have exactly the same implementation", priority=Priority.MAJOR, tags={"bug"})
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="10min")
public class IdenticalCasesInSwitchCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.SWITCH_STATEMENT, (Object)Tree.Kind.IF_STATEMENT, (Object)Tree.Kind.CONDITIONAL_EXPRESSION);
    }

    public void visitNode(Tree node) {
        if (node.is(new Tree.Kind[]{Tree.Kind.SWITCH_STATEMENT})) {
            this.checkSwitchStatement((SwitchStatementTree)node);
        } else if (node.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) {
            this.checkIfStatement((IfStatementTree)node);
        } else {
            this.checkConditionalExpression((ConditionalExpressionTree)node);
        }
    }

    public void checkSwitchStatement(SwitchStatementTree node) {
        int index = 0;
        List cases = node.cases();
        HashSet reportedLabels = Sets.newHashSet();
        for (CaseGroupTree caseGroupTree : cases) {
            for (int i = ++index; i < cases.size(); ++i) {
                CaseLabelTree labelToReport;
                if (!SyntacticEquivalence.areEquivalent((List)caseGroupTree.body(), (List)((CaseGroupTree)cases.get(i)).body()) || reportedLabels.contains(labelToReport = IdenticalCasesInSwitchCheck.getLastLabel((CaseGroupTree)cases.get(i)))) continue;
                reportedLabels.add(labelToReport);
                this.createIssue((Tree)labelToReport, "case", (Tree)caseGroupTree);
            }
        }
    }

    private void checkIfStatement(IfStatementTree node) {
        StatementTree thenStatement = node.thenStatement();
        StatementTree elseStatement = node.elseStatement();
        while (elseStatement != null && elseStatement.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) {
            IfStatementTree ifStatement = (IfStatementTree)elseStatement;
            if (IdenticalCasesInSwitchCheck.areIfBlocksSyntacticalEquivalent(thenStatement, ifStatement.thenStatement())) {
                this.createIssue((Tree)ifStatement.thenStatement(), "branch", (Tree)thenStatement);
                break;
            }
            elseStatement = ifStatement.elseStatement();
        }
        if (elseStatement != null && IdenticalCasesInSwitchCheck.areIfBlocksSyntacticalEquivalent(thenStatement, elseStatement)) {
            this.createIssue((Tree)elseStatement, "branch", (Tree)thenStatement);
        }
    }

    private void createIssue(Tree node, String type, Tree secondary) {
        this.reportIssue(node, IdenticalCasesInSwitchCheck.issueMessage(type, secondary), (List)ImmutableList.of((Object)new JavaFileScannerContext.Location("Duplicated block", secondary)), null);
    }

    private static boolean areIfBlocksSyntacticalEquivalent(StatementTree first, StatementTree second) {
        return IdenticalCasesInSwitchCheck.isNotEmptyBlock(first) && SyntacticEquivalence.areEquivalent((Tree)first, (Tree)second);
    }

    private static boolean isNotEmptyBlock(StatementTree node) {
        return !node.is(new Tree.Kind[]{Tree.Kind.BLOCK}) || !((BlockTree)node).body().isEmpty();
    }

    private static String issueMessage(String type, Tree node) {
        return "This " + type + "'s code block is the same as the block for the " + type + " on line " + FirstSyntaxTokenFinder.firstSyntaxToken((Tree)node).line() + ".";
    }

    private void checkConditionalExpression(ConditionalExpressionTree node) {
        if (SyntacticEquivalence.areEquivalent((Tree)ExpressionsHelper.skipParentheses(node.trueExpression()), (Tree)ExpressionsHelper.skipParentheses(node.falseExpression()))) {
            this.reportIssue((Tree)node.questionToken(), "This conditional operation returns the same value whether the condition is \"true\" or \"false\".");
        }
    }

    private static CaseLabelTree getLastLabel(CaseGroupTree cases) {
        return (CaseLabelTree)cases.labels().get(cases.labels().size() - 1);
    }
}

