/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.Iterables;
import javax.annotation.CheckForNull;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.DoWhileStatementTree;
import org.sonar.plugins.java.api.tree.EnumConstantTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.LabeledStatementTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.StaticInitializerTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.SynchronizedStatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.TypeParameters;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;

public abstract class LeftCurlyBraceBaseTreeVisitor
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    protected void addIssue(SyntaxToken openBraceToken, JavaCheck check, String message) {
        this.context.addIssue((Tree)openBraceToken, check, message);
    }

    protected abstract void checkTokens(SyntaxToken var1, SyntaxToken var2);

    public void visitClass(ClassTree tree) {
        SyntaxToken lastToken = this.getLastTokenFromSignature(tree);
        if (lastToken != null) {
            this.checkTokens(lastToken, tree.openBraceToken());
        }
        super.visitClass(tree);
    }

    @CheckForNull
    private SyntaxToken getLastTokenFromSignature(ClassTree classTree) {
        ListTree superInterfaces = classTree.superInterfaces();
        if (!superInterfaces.isEmpty()) {
            return LeftCurlyBraceBaseTreeVisitor.getIdentifierToken((TypeTree)Iterables.getLast((Iterable)superInterfaces));
        }
        TypeTree superClass = classTree.superClass();
        if (superClass != null) {
            return LeftCurlyBraceBaseTreeVisitor.getIdentifierToken(superClass);
        }
        TypeParameters typeParameters = classTree.typeParameters();
        if (!typeParameters.isEmpty()) {
            return typeParameters.closeBracketToken();
        }
        IdentifierTree simpleName = classTree.simpleName();
        if (simpleName != null) {
            return simpleName.identifierToken();
        }
        return null;
    }

    private static SyntaxToken getIdentifierToken(TypeTree typeTree) {
        if (typeTree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return ((IdentifierTree)typeTree).identifierToken();
        }
        if (typeTree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return ((MemberSelectExpressionTree)typeTree).identifier().identifierToken();
        }
        return ((ParameterizedTypeTree)typeTree).typeArguments().closeBracketToken();
    }

    public void visitIfStatement(IfStatementTree tree) {
        this.checkBlock(tree.closeParenToken(), (Tree)tree.thenStatement());
        if (tree.elseKeyword() != null) {
            this.checkBlock(tree.elseKeyword(), (Tree)tree.elseStatement());
        }
        super.visitIfStatement(tree);
    }

    public void visitSwitchStatement(SwitchStatementTree tree) {
        this.checkTokens(tree.closeParenToken(), tree.openBraceToken());
        super.visitSwitchStatement(tree);
    }

    public void visitWhileStatement(WhileStatementTree tree) {
        this.checkBlock(tree.closeParenToken(), (Tree)tree.statement());
        super.visitWhileStatement(tree);
    }

    public void visitDoWhileStatement(DoWhileStatementTree tree) {
        this.checkBlock(tree.doKeyword(), (Tree)tree.statement());
        super.visitDoWhileStatement(tree);
    }

    public void visitForStatement(ForStatementTree tree) {
        this.checkBlock(tree.closeParenToken(), (Tree)tree.statement());
        super.visitForStatement(tree);
    }

    public void visitForEachStatement(ForEachStatement tree) {
        this.checkBlock(tree.closeParenToken(), (Tree)tree.statement());
        super.visitForEachStatement(tree);
    }

    public void visitSynchronizedStatement(SynchronizedStatementTree tree) {
        this.checkBlock(tree.closeParenToken(), (Tree)tree.block());
        super.visitSynchronizedStatement(tree);
    }

    public void visitLabeledStatement(LabeledStatementTree tree) {
        this.checkBlock(tree.colonToken(), (Tree)tree.statement());
        super.visitLabeledStatement(tree);
    }

    public void visitTryStatement(TryStatementTree tree) {
        SyntaxToken closeParenToken = tree.closeParenToken();
        if (closeParenToken != null) {
            this.checkBlock(closeParenToken, (Tree)tree.block());
        } else {
            this.checkBlock(tree.tryKeyword(), (Tree)tree.block());
        }
        SyntaxToken finallyKeyword = tree.finallyKeyword();
        if (finallyKeyword != null) {
            this.checkBlock(finallyKeyword, (Tree)tree.finallyBlock());
        }
        super.visitTryStatement(tree);
    }

    public void visitCatch(CatchTree tree) {
        this.checkBlock(tree.closeParenToken(), (Tree)tree.block());
        super.visitCatch(tree);
    }

    public void visitNewClass(NewClassTree tree) {
        ClassTree classBody = tree.classBody();
        if (classBody != null && tree.arguments().closeParenToken() != null) {
            this.checkTokens(tree.arguments().closeParenToken(), classBody.openBraceToken());
        }
        super.visitNewClass(tree);
    }

    public void visitMethod(MethodTree tree) {
        BlockTree blockTree = tree.block();
        if (blockTree != null) {
            this.checkTokens(this.getLastTokenFromSignature(tree), blockTree.openBraceToken());
        }
        super.visitMethod(tree);
    }

    private SyntaxToken getLastTokenFromSignature(MethodTree methodTree) {
        if (methodTree.throwsClauses().isEmpty()) {
            return methodTree.closeParenToken();
        }
        return LeftCurlyBraceBaseTreeVisitor.getIdentifierToken((TypeTree)Iterables.getLast((Iterable)methodTree.throwsClauses()));
    }

    public void visitBlock(BlockTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.STATIC_INITIALIZER})) {
            StaticInitializerTree staticInitializerTree = (StaticInitializerTree)tree;
            this.checkTokens(staticInitializerTree.staticKeyword(), staticInitializerTree.openBraceToken());
        }
        super.visitBlock(tree);
    }

    public void visitEnumConstant(EnumConstantTree tree) {
        NewClassTree initializer = tree.initializer();
        ClassTree classBody = initializer.classBody();
        if (classBody != null) {
            SyntaxToken openBraceToken = classBody.openBraceToken();
            if (initializer.arguments().closeParenToken() != null) {
                this.checkTokens(initializer.arguments().closeParenToken(), openBraceToken);
            } else {
                this.checkTokens(tree.simpleName().identifierToken(), openBraceToken);
            }
        }
        super.visitEnumConstant(tree);
    }

    private void checkBlock(SyntaxToken previousToken, Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            this.checkTokens(previousToken, ((BlockTree)tree).openBraceToken());
        }
    }
}

