/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.EnumConstantTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S109", name="Magic numbers should not be used", priority=Priority.MINOR, tags={"brain-overload"})
@SqaleSubCharacteristic(value="DATA_CHANGEABILITY")
@SqaleConstantRemediation(value="5min")
public class MagicNumberCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String DEFAULT_AUTHORIZED_NUMBERS = "-1,0,1";
    @RuleProperty(key="Authorized numbers", description="Comma separated list of authorized numbers. Example: -1,0,1,2", defaultValue="-1,0,1")
    public String authorizedNumbers = "-1,0,1";
    private List<BigDecimal> authorizedNumbersList = null;
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.authorizedNumbersList = new ArrayList<BigDecimal>();
        for (String s : this.authorizedNumbers.split(",")) {
            this.authorizedNumbersList.add(new BigDecimal(s));
        }
        this.scan((Tree)context.getTree());
    }

    public void visitEnumConstant(EnumConstantTree tree) {
        this.scan((Tree)tree.initializer().classBody());
    }

    public void visitLiteral(LiteralTree tree) {
        if (MagicNumberCheck.isNumberLiteral(tree)) {
            DecimalFormat decimalFormat = new DecimalFormat();
            decimalFormat.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.ENGLISH));
            decimalFormat.setParseBigDecimal(true);
            BigDecimal checked = null;
            try {
                checked = (BigDecimal)decimalFormat.parse(tree.value());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (checked != null && !this.isExcluded(checked)) {
                this.context.addIssue((Tree)tree, (JavaCheck)this, "Assign this magic number " + tree.value() + " to a well-named constant, and use the constant instead.");
            }
        }
    }

    private static boolean isNumberLiteral(LiteralTree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.DOUBLE_LITERAL, Tree.Kind.FLOAT_LITERAL, Tree.Kind.LONG_LITERAL, Tree.Kind.INT_LITERAL});
    }

    private boolean isExcluded(BigDecimal bigDecimal) {
        for (BigDecimal bd : this.authorizedNumbersList) {
            if (bigDecimal.compareTo(bd) != 0) continue;
            return true;
        }
        return false;
    }

    public void visitAnnotation(AnnotationTree annotationTree) {
    }

    public void visitVariable(VariableTree tree) {
        boolean arrayNotInitialized;
        ExpressionTree initializer = tree.initializer();
        boolean bl = arrayNotInitialized = initializer != null && initializer.is(new Tree.Kind[]{Tree.Kind.NEW_ARRAY}) && ((NewArrayTree)initializer).initializers().isEmpty();
        if (arrayNotInitialized || !ModifiersUtils.hasModifier((ModifiersTree)tree.modifiers(), (Modifier)Modifier.FINAL)) {
            super.visitVariable(tree);
        }
    }
}

