/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.DoWhileStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2259", name="Null pointers should not be dereferenced", priority=Priority.BLOCKER, tags={"bug", "cert", "cwe", "owasp-a1", "owasp-a2", "owasp-a6", "security"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="10min")
public class NullPointerCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String MESSAGE_NULLABLE_EXPRESSION = "NullPointerException might be thrown as '%s' is nullable here";
    private static final String MESSAGE_NULL_LITERAL = "null is dereferenced";
    @Nullable
    private ConditionalState currentConditionalState;
    private JavaFileScannerContext context;
    private State currentState;
    private SemanticModel semanticModel;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.semanticModel = (SemanticModel)context.getSemanticModel();
        if (this.semanticModel != null) {
            context.getTree().accept((TreeVisitor)this);
        }
    }

    public void visitArrayAccessExpression(ArrayAccessExpressionTree tree) {
        this.checkForIssue((Tree)tree.expression(), MESSAGE_NULLABLE_EXPRESSION, MESSAGE_NULL_LITERAL);
        super.visitArrayAccessExpression(tree);
    }

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        Symbol identifierSymbol;
        super.visitAssignmentExpression(tree);
        if (tree.variable().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && (identifierSymbol = ((IdentifierTree)tree.variable()).symbol()).isVariableSymbol()) {
            this.currentState.setVariableValue((Symbol.VariableSymbol)identifierSymbol, this.checkNullity((Tree)tree.expression()));
        }
    }

    public void visitBinaryExpression(BinaryExpressionTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_AND})) {
            this.visitorConditionalAnd(tree);
            return;
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_OR})) {
            this.visitConditionalOr(tree);
            return;
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.EQUAL_TO})) {
            this.visitRelationalEqualTo(tree);
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.NOT_EQUAL_TO})) {
            this.visitRelationalNotEqualTo(tree);
        }
        super.visitBinaryExpression(tree);
    }

    public void visitClass(ClassTree tree) {
        State oldState = this.currentState;
        this.currentState = new State();
        this.scan(tree.members());
        this.currentState = oldState;
    }

    public void visitCompilationUnit(CompilationUnitTree tree) {
        this.scan(tree.types());
    }

    public void visitConditionalExpression(ConditionalExpressionTree tree) {
        ConditionalState conditionalState = this.visitCondition(tree.condition());
        this.currentState = conditionalState.trueState;
        tree.trueExpression().accept((TreeVisitor)this);
        this.currentState = conditionalState.falseState;
        tree.falseExpression().accept((TreeVisitor)this);
        this.currentState = this.currentState.parentState.mergeValues(conditionalState.trueState, conditionalState.falseState);
    }

    public void visitDoWhileStatement(DoWhileStatementTree tree) {
        this.currentState.invalidateVariables(new AssignmentVisitor().findAssignedVariables((Tree)tree.statement()));
        this.currentState = new State(this.currentState);
        this.scan((Tree)tree.statement());
        this.scan((Tree)tree.condition());
        this.restorePreviousState();
    }

    public void visitForStatement(ForStatementTree tree) {
        this.scan(tree.initializer());
        ConditionalState conditionalState = this.visitCondition(tree.condition());
        Set<Symbol.VariableSymbol> assignedVariables = new AssignmentVisitor().findAssignedVariables((Tree)tree.statement());
        assignedVariables.addAll(new AssignmentVisitor().findAssignedVariables((List<? extends Tree>)tree.update()));
        this.currentState = conditionalState.trueState;
        this.currentState.invalidateVariables(assignedVariables);
        this.scan((Tree)tree.statement());
        this.scan(tree.update());
        this.restorePreviousState();
        this.currentState.invalidateVariables(assignedVariables);
    }

    public void visitForEachStatement(ForEachStatement tree) {
        this.scan((Tree)tree.expression());
        this.currentState.invalidateVariables(new AssignmentVisitor().findAssignedVariables((Tree)tree.statement()));
        this.currentState = new State(this.currentState);
        this.scan((Tree)tree.statement());
        this.restorePreviousState();
    }

    public void visitIfStatement(IfStatementTree tree) {
        ConditionalState conditionalState = this.visitCondition(tree.condition());
        this.currentState = conditionalState.trueState;
        tree.thenStatement().accept((TreeVisitor)this);
        if (tree.elseStatement() != null) {
            this.currentState = conditionalState.falseState;
            tree.elseStatement().accept((TreeVisitor)this);
        }
        this.currentState = this.currentState.parentState.mergeValues(conditionalState.trueState, conditionalState.falseState);
    }

    public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
        this.checkForIssue((Tree)tree.expression(), MESSAGE_NULLABLE_EXPRESSION, MESSAGE_NULL_LITERAL);
        super.visitMemberSelectExpression(tree);
    }

    public void visitMethod(MethodTree tree) {
        State oldState = this.currentState;
        this.currentState = new State();
        this.scan((Tree)tree.block());
        this.currentState = oldState;
    }

    public void visitMethodInvocation(MethodInvocationTree tree) {
        JavaSymbol.MethodJavaSymbol methodSymbol;
        List parameters;
        Symbol symbol = tree.symbol();
        if (symbol.isMethodSymbol() && !(parameters = (methodSymbol = (JavaSymbol.MethodJavaSymbol)symbol).getParameters().scopeSymbols()).isEmpty()) {
            for (int i = 0; i < tree.arguments().size(); ++i) {
                if (NullPointerCheck.checkNullity((Symbol)parameters.get(i < parameters.size() ? i : parameters.size() - 1)) != AbstractValue.NOTNULL) continue;
                this.checkForIssue((Tree)tree.arguments().get(i), String.format("'%%s' is nullable here and method '%s' does not accept nullable argument", methodSymbol.name()), String.format("method '%s' does not accept nullable argument", methodSymbol.name()));
            }
        }
        super.visitMethodInvocation(tree);
    }

    public void visitSwitchStatement(SwitchStatementTree tree) {
        this.checkForIssue((Tree)tree.expression(), MESSAGE_NULLABLE_EXPRESSION, MESSAGE_NULL_LITERAL);
        this.scan((Tree)tree.expression());
        Set<Symbol.VariableSymbol> variables = new AssignmentVisitor().findAssignedVariables(tree.cases());
        this.currentState.invalidateVariables(variables);
        for (CaseGroupTree caseTree : tree.cases()) {
            this.currentState = new State(this.currentState);
            this.scan((Tree)caseTree);
            this.restorePreviousState();
        }
    }

    public void visitTryStatement(TryStatementTree tree) {
        State blockState;
        this.scan(tree.resources());
        this.currentState = blockState = new State(this.currentState);
        this.scan((Tree)tree.block());
        for (CatchTree catchTree : tree.catches()) {
            this.currentState = new State(blockState.parentState);
            this.scan((Tree)catchTree);
            blockState.mergeValues(this.currentState, null);
        }
        if (tree.finallyBlock() != null) {
            this.currentState = new State(blockState.parentState);
            this.scan((Tree)tree.finallyBlock());
            blockState.mergeValues(this.currentState, null);
        }
        this.currentState = blockState.parentState.mergeValues(blockState, null);
    }

    public void visitVariable(VariableTree tree) {
        if (tree.initializer() != null) {
            this.scan((Tree)tree.initializer());
            this.currentState.setVariableValue((Symbol.VariableSymbol)tree.symbol(), this.checkNullity((Tree)tree.initializer()));
        }
    }

    public void visitWhileStatement(WhileStatementTree tree) {
        ConditionalState conditionalState = this.visitCondition(tree.condition());
        Set<Symbol.VariableSymbol> assignedVariables = new AssignmentVisitor().findAssignedVariables((Tree)tree.statement());
        this.currentState = conditionalState.trueState;
        this.currentState.invalidateVariables(assignedVariables);
        this.scan((Tree)tree.statement());
        this.restorePreviousState();
        this.currentState.invalidateVariables(assignedVariables);
    }

    private static AbstractValue checkNullity(Symbol symbol) {
        if (symbol.metadata().isAnnotatedWith("javax.annotation.Nonnull")) {
            return AbstractValue.NOTNULL;
        }
        if (symbol.metadata().isAnnotatedWith("javax.annotation.CheckForNull")) {
            return AbstractValue.NULL;
        }
        return AbstractValue.UNKNOWN;
    }

    public AbstractValue checkNullity(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return this.checkNullity((IdentifierTree)tree);
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            Symbol symbol = ((MethodInvocationTree)tree).symbol();
            if (symbol.isMethodSymbol()) {
                return NullPointerCheck.checkNullity(symbol);
            }
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL})) {
            return AbstractValue.NULL;
        }
        return AbstractValue.UNKNOWN;
    }

    public AbstractValue checkNullity(IdentifierTree tree) {
        Symbol symbol = tree.symbol();
        if (NullPointerCheck.isSymbolLocalVariableOrMethodParameter(symbol)) {
            AbstractValue value = this.currentState.getVariableValue((Symbol.VariableSymbol)symbol);
            if (value != AbstractValue.UNSET) {
                return value;
            }
            return NullPointerCheck.checkNullity(symbol);
        }
        return AbstractValue.UNKNOWN;
    }

    private void checkForIssue(Tree tree, String nullableMessage, String nullMessage) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            Symbol symbol = ((IdentifierTree)tree).symbol();
            if (this.checkNullity(tree) == AbstractValue.NULL) {
                this.currentState.setVariableValue((Symbol.VariableSymbol)symbol, AbstractValue.UNKNOWN);
                this.context.addIssue(tree, (JavaCheck)this, String.format(nullableMessage, symbol.name()));
            }
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            Symbol symbol = ((MethodInvocationTree)tree).symbol();
            if (NullPointerCheck.checkNullity(symbol) == AbstractValue.NULL) {
                this.context.addIssue(tree, (JavaCheck)this, String.format(nullableMessage, symbol.name()));
            }
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL})) {
            this.context.addIssue(tree, (JavaCheck)this, nullMessage);
        }
    }

    private static boolean isSymbolLocalVariableOrMethodParameter(Symbol symbol) {
        return symbol.isVariableSymbol() && symbol.owner().isMethodSymbol();
    }

    private void restorePreviousState() {
        this.currentState = this.currentState.parentState;
    }

    private ConditionalState visitCondition(ExpressionTree tree) {
        ConditionalState conditionalState;
        ConditionalState oldConditionalState = this.currentConditionalState;
        this.currentConditionalState = conditionalState = new ConditionalState(this.currentState);
        this.scan((Tree)tree);
        this.currentConditionalState = oldConditionalState;
        return conditionalState;
    }

    private ConditionalState visitCondition(ExpressionTree tree, State newState) {
        State oldState = this.currentState;
        this.currentState = newState;
        ConditionalState result = this.visitCondition(tree);
        this.currentState = oldState;
        return result;
    }

    private void visitorConditionalAnd(BinaryExpressionTree tree) {
        ConditionalState leftConditionalState = this.visitCondition(tree.leftOperand());
        ConditionalState rightConditionalState = this.visitCondition(tree.rightOperand(), leftConditionalState.trueState);
        if (this.currentConditionalState != null) {
            this.currentConditionalState.mergeConditionalAnd(leftConditionalState, rightConditionalState);
        }
    }

    private void visitConditionalOr(BinaryExpressionTree tree) {
        ConditionalState leftConditionalState = this.visitCondition(tree.leftOperand());
        ConditionalState rightConditionalState = this.visitCondition(tree.rightOperand(), leftConditionalState.falseState);
        if (this.currentConditionalState != null) {
            this.currentConditionalState.mergeConditionalOr(leftConditionalState, rightConditionalState);
        }
    }

    @Nullable
    private static Symbol.VariableSymbol extractRelationalSymbol(BinaryExpressionTree tree) {
        Symbol symbol = null;
        if (tree.leftOperand().is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL}) && tree.rightOperand().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            symbol = ((IdentifierTree)tree.rightOperand()).symbol();
        } else if (tree.leftOperand().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && tree.rightOperand().is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL})) {
            symbol = ((IdentifierTree)tree.leftOperand()).symbol();
        }
        if (symbol == null || !symbol.isVariableSymbol()) {
            return null;
        }
        return (Symbol.VariableSymbol)symbol;
    }

    private void visitRelationalEqualTo(BinaryExpressionTree tree) {
        Symbol.VariableSymbol symbol = NullPointerCheck.extractRelationalSymbol(tree);
        if (symbol != null && this.currentConditionalState != null) {
            this.currentConditionalState.trueState.setVariableValue(symbol, AbstractValue.NULL);
            this.currentConditionalState.falseState.setVariableValue(symbol, AbstractValue.NOTNULL);
        }
    }

    private void visitRelationalNotEqualTo(BinaryExpressionTree tree) {
        Symbol.VariableSymbol symbol = NullPointerCheck.extractRelationalSymbol(tree);
        if (symbol != null && this.currentConditionalState != null) {
            this.currentConditionalState.trueState.setVariableValue(symbol, AbstractValue.NOTNULL);
            this.currentConditionalState.falseState.setVariableValue(symbol, AbstractValue.NULL);
        }
    }

    @VisibleForTesting
    static class State {
        @Nullable
        final State parentState;
        final Map<Symbol.VariableSymbol, AbstractValue> variables;

        public State() {
            this.parentState = null;
            this.variables = new HashMap<Symbol.VariableSymbol, AbstractValue>();
        }

        public State(State parentState) {
            this.parentState = parentState;
            this.variables = new HashMap<Symbol.VariableSymbol, AbstractValue>();
        }

        public AbstractValue getVariableValue(Symbol.VariableSymbol variable) {
            State state = this;
            while (state != null) {
                AbstractValue result = state.variables.get(variable);
                if (result != null) {
                    return result;
                }
                state = state.parentState;
            }
            return AbstractValue.UNSET;
        }

        public void setVariableValue(Symbol.VariableSymbol variable, AbstractValue value) {
            this.variables.put(variable, value);
        }

        public void copyValuesFrom(State fromState) {
            for (Symbol.VariableSymbol variable : fromState.variables.keySet()) {
                this.setVariableValue(variable, fromState.getVariableValue(variable));
            }
        }

        public State invalidateValues() {
            for (Symbol.VariableSymbol variable : this.variables.keySet()) {
                this.setVariableValue(variable, AbstractValue.UNKNOWN);
            }
            return this;
        }

        public State invalidateVariables(Set<Symbol.VariableSymbol> variables) {
            for (Symbol.VariableSymbol variable : variables) {
                this.setVariableValue(variable, AbstractValue.UNKNOWN);
            }
            return this;
        }

        public State mergeValues(State state1, @Nullable State state2) {
            HashSet<Symbol.VariableSymbol> mergeVariables = new HashSet<Symbol.VariableSymbol>();
            mergeVariables.addAll(state1.variables.keySet());
            if (state2 != null) {
                mergeVariables.addAll(state2.variables.keySet());
            }
            for (Symbol.VariableSymbol variable : mergeVariables) {
                AbstractValue falseValue;
                AbstractValue currentValue = this.getVariableValue(variable);
                AbstractValue trueValue = state1.variables.get(variable);
                if (trueValue == null) {
                    trueValue = currentValue;
                }
                AbstractValue abstractValue = falseValue = state2 != null ? state2.variables.get(variable) : currentValue;
                if (falseValue == null) {
                    falseValue = currentValue;
                }
                this.setVariableValue(variable, trueValue == falseValue ? trueValue : AbstractValue.UNKNOWN);
            }
            return this;
        }
    }

    @VisibleForTesting
    static class ConditionalState {
        final State falseState;
        final State trueState;

        ConditionalState(State currentState) {
            this.falseState = new State(currentState);
            this.trueState = new State(currentState);
        }

        void mergeConditionalAnd(ConditionalState leftConditionalState, ConditionalState rightConditionalState) {
            this.trueState.copyValuesFrom(leftConditionalState.trueState);
            this.trueState.copyValuesFrom(rightConditionalState.trueState);
            this.falseState.copyValuesFrom(leftConditionalState.falseState.invalidateValues());
            this.falseState.copyValuesFrom(rightConditionalState.falseState.invalidateValues());
        }

        void mergeConditionalOr(ConditionalState leftConditionalState, ConditionalState rightConditionalState) {
            this.trueState.copyValuesFrom(leftConditionalState.trueState.invalidateValues());
            this.trueState.copyValuesFrom(rightConditionalState.trueState.invalidateValues());
            this.falseState.copyValuesFrom(leftConditionalState.falseState);
            this.falseState.copyValuesFrom(rightConditionalState.falseState);
        }
    }

    public static enum AbstractValue {
        UNSET,
        NOTNULL,
        NULL,
        UNKNOWN;

    }

    @VisibleForTesting
    static class AssignmentVisitor
    extends BaseTreeVisitor {
        @VisibleForTesting
        Set<Symbol.VariableSymbol> assignedSymbols = new HashSet<Symbol.VariableSymbol>();

        AssignmentVisitor() {
        }

        public Set<Symbol.VariableSymbol> findAssignedVariables(Tree tree) {
            tree.accept((TreeVisitor)this);
            return this.assignedSymbols;
        }

        public Set<Symbol.VariableSymbol> findAssignedVariables(List<? extends Tree> trees) {
            for (Tree tree : trees) {
                tree.accept((TreeVisitor)this);
            }
            return this.assignedSymbols;
        }

        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            if (tree.variable().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                this.registerAssignedSymbol(((IdentifierTree)tree.variable()).symbol());
            }
            super.visitAssignmentExpression(tree);
        }

        @VisibleForTesting
        void registerAssignedSymbol(Symbol symbol) {
            if (symbol.isVariableSymbol()) {
                this.assignedSymbols.add((Symbol.VariableSymbol)symbol);
            }
        }
    }
}

