/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1301", name="\"switch\" statements should have at least 3 \"case\" clauses", priority=Priority.MINOR, tags={"misra"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="5min")
public class SwitchAtLeastThreeCasesCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitSwitchStatement(SwitchStatementTree tree) {
        int count = 0;
        for (CaseGroupTree caseGroup : tree.cases()) {
            count += caseGroup.labels().size();
        }
        if (count < 3) {
            this.context.addIssue((Tree)tree, (JavaCheck)this, "Replace this \"switch\" statement by \"if\" statements to increase readability.");
        }
        super.visitSwitchStatement(tree);
    }
}

