/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multiset;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.syntaxtoken.FirstSyntaxTokenFinder;
import org.sonar.plugins.java.api.tree.AssertStatementTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.BreakStatementTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ContinueStatementTree;
import org.sonar.plugins.java.api.tree.DoWhileStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.SynchronizedStatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S00122", name="Statements should be on separate lines", priority=Priority.MINOR, tags={"convention"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="1min")
public class TooManyStatementsPerLine_S00122_Check
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD, (Object)Tree.Kind.CONSTRUCTOR, (Object)Tree.Kind.STATIC_INITIALIZER);
    }

    public void visitNode(Tree tree) {
        BlockTree block = tree.is(new Tree.Kind[]{Tree.Kind.STATIC_INITIALIZER}) ? (BlockTree)tree : ((MethodTree)tree).block();
        if (block != null) {
            StatementVisitor visitor = new StatementVisitor();
            block.accept((TreeVisitor)visitor);
            for (Multiset.Entry entry : visitor.statementsPerLine.entrySet()) {
                int count = entry.getCount();
                if (count <= 1) continue;
                this.addIssue((Integer)entry.getElement(), "At most one statement is allowed per line, but " + count + " statements were found on this line.");
            }
        }
    }

    private static class StatementVisitor
    extends BaseTreeVisitor {
        private final Multiset<Integer> statementsPerLine = HashMultiset.create();

        private StatementVisitor() {
        }

        public void visitClass(ClassTree tree) {
        }

        public void visitAssertStatement(AssertStatementTree tree) {
            this.addLines(tree.assertKeyword(), tree.semicolonToken());
        }

        public void visitBreakStatement(BreakStatementTree tree) {
            this.addLines(tree.breakKeyword(), tree.semicolonToken());
        }

        public void visitContinueStatement(ContinueStatementTree tree) {
            this.addLines(tree.continueKeyword(), tree.semicolonToken());
        }

        public void visitReturnStatement(ReturnStatementTree tree) {
            this.addLines(tree.returnKeyword(), tree.semicolonToken());
        }

        public void visitThrowStatement(ThrowStatementTree tree) {
            this.addLines(tree.throwKeyword(), tree.semicolonToken());
        }

        public void visitExpressionStatement(ExpressionStatementTree tree) {
            SyntaxToken firstToken = FirstSyntaxTokenFinder.firstSyntaxToken((Tree)tree);
            if (firstToken != null) {
                this.addLines(firstToken, tree.semicolonToken());
            } else {
                this.addLine(tree.semicolonToken());
            }
        }

        public void visitIfStatement(IfStatementTree tree) {
            this.addLine(tree.ifKeyword());
            StatementTree thenStatement = tree.thenStatement();
            StatementTree elseStatement = tree.elseStatement();
            this.scan((Tree)thenStatement);
            this.scan((Tree)elseStatement);
            if (elseStatement == null) {
                this.addLineOfCloseBrace(tree.ifKeyword(), thenStatement);
            } else {
                this.addLineOfCloseBrace(tree.ifKeyword(), elseStatement);
            }
        }

        private void addLineOfCloseBrace(SyntaxToken startToken, StatementTree tree) {
            if (tree.is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
                SyntaxToken closeBraceToken = ((BlockTree)tree).closeBraceToken();
                if (startToken.line() != closeBraceToken.line() && !this.statementsPerLine.contains((Object)closeBraceToken.line())) {
                    this.addLine(closeBraceToken);
                }
            }
        }

        public void visitSynchronizedStatement(SynchronizedStatementTree tree) {
            this.addLine(tree.synchronizedKeyword());
            this.addLineOfCloseBrace(tree.synchronizedKeyword(), (StatementTree)tree.block());
            this.scan((Tree)tree.block());
        }

        public void visitSwitchStatement(SwitchStatementTree tree) {
            this.addLines(tree.switchKeyword(), tree.openBraceToken());
            this.scan(tree.cases());
            this.addLine(tree.closeBraceToken());
        }

        public void visitVariable(VariableTree tree) {
            SyntaxToken endToken = tree.endToken();
            if (endToken != null && ";".equals(endToken.text())) {
                this.addLine(endToken);
            }
        }

        public void visitWhileStatement(WhileStatementTree tree) {
            this.addLines(tree.whileKeyword(), tree.closeParenToken());
            this.addLineOfCloseBrace(tree.whileKeyword(), tree.statement());
            this.scan((Tree)tree.statement());
        }

        public void visitDoWhileStatement(DoWhileStatementTree tree) {
            this.addLine(tree.doKeyword());
            if (tree.doKeyword().line() != tree.whileKeyword().line()) {
                this.addLines(tree.whileKeyword(), tree.semicolonToken());
            }
            this.scan((Tree)tree.statement());
        }

        public void visitForStatement(ForStatementTree tree) {
            this.addLines(tree.forKeyword(), tree.closeParenToken());
            this.addLineOfCloseBrace(tree.forKeyword(), tree.statement());
            this.scan((Tree)tree.statement());
        }

        public void visitForEachStatement(ForEachStatement tree) {
            this.addLines(tree.forKeyword(), tree.closeParenToken());
            this.addLineOfCloseBrace(tree.forKeyword(), tree.statement());
            this.scan((Tree)tree.statement());
        }

        public void visitTryStatement(TryStatementTree tree) {
            if (tree.resources().isEmpty()) {
                this.addLine(tree.tryKeyword());
            } else {
                this.addLines(tree.tryKeyword(), tree.closeParenToken());
            }
            this.scan((Tree)tree.block());
            this.scan(tree.catches());
            if (tree.finallyKeyword() != null) {
                this.addLine(tree.finallyKeyword());
            }
            this.scan((Tree)tree.finallyBlock());
        }

        private void addLine(SyntaxToken token) {
            this.statementsPerLine.add((Object)token.line());
        }

        private void addLines(SyntaxToken startToken, SyntaxToken endToken) {
            this.addLine(startToken);
            if (startToken.line() != endToken.line()) {
                this.addLine(endToken);
            }
        }
    }
}

