/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.symexec;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.java.symexec.SymbolicBooleanConstraint;
import org.sonar.java.symexec.SymbolicRelation;
import org.sonar.java.symexec.SymbolicValue;

public class ExecutionState {
    @VisibleForTesting
    static final Table<SymbolicRelation, SymbolicRelation, SymbolicBooleanConstraint> RELATION_RELATION_MAP = HashBasedTable.create();
    @Nullable
    @VisibleForTesting
    final ExecutionState parentState;
    @VisibleForTesting
    final Table<SymbolicValue, SymbolicValue, SymbolicRelation> relations;

    public ExecutionState() {
        this.parentState = null;
        this.relations = HashBasedTable.create();
    }

    ExecutionState(ExecutionState parentState) {
        this.parentState = parentState;
        this.relations = HashBasedTable.create();
    }

    @VisibleForTesting
    SymbolicRelation getRelation(SymbolicValue leftValue, SymbolicValue rightValue) {
        SymbolicRelation result = (SymbolicRelation)((Object)this.relations.get((Object)leftValue, (Object)rightValue));
        if (result != null) {
            return result;
        }
        return this.parentState != null ? this.parentState.getRelation(leftValue, rightValue) : SymbolicRelation.UNKNOWN;
    }

    SymbolicBooleanConstraint evaluateRelation(SymbolicValue leftValue, SymbolicRelation relation, SymbolicValue rightValue) {
        return (SymbolicBooleanConstraint)((Object)RELATION_RELATION_MAP.get((Object)this.getRelation(leftValue, rightValue), (Object)relation));
    }

    ExecutionState setRelation(SymbolicValue leftValue, SymbolicRelation relation, SymbolicValue rightValue) {
        if (!leftValue.equals(rightValue)) {
            this.relations.put((Object)leftValue, (Object)rightValue, (Object)relation);
            this.relations.put((Object)rightValue, (Object)leftValue, (Object)relation.swap());
        }
        return this;
    }

    void mergeRelations(Iterable<ExecutionState> states) {
        for (Map.Entry entry : this.findRelatedValues(states).entries()) {
            SymbolicRelation relation = null;
            for (ExecutionState state : states) {
                relation = state.getRelation((SymbolicValue)entry.getKey(), (SymbolicValue)entry.getValue()).union(relation);
            }
            if (relation == null) {
                relation = SymbolicRelation.UNKNOWN;
            }
            if (this.getRelation((SymbolicValue)entry.getKey(), (SymbolicValue)entry.getValue()) == relation) continue;
            this.relations.put(entry.getKey(), entry.getValue(), (Object)relation);
            this.relations.put(entry.getValue(), entry.getKey(), (Object)relation.swap());
        }
    }

    private Multimap<SymbolicValue, SymbolicValue> findRelatedValues(Iterable<ExecutionState> states) {
        HashMultimap result = HashMultimap.create();
        Iterator<ExecutionState> i$ = states.iterator();
        while (i$.hasNext()) {
            ExecutionState state;
            ExecutionState current = state = i$.next();
            while (!current.equals(this)) {
                for (Map.Entry leftEntry : current.relations.rowMap().entrySet()) {
                    result.putAll(leftEntry.getKey(), ((Map)leftEntry.getValue()).keySet());
                }
                current = current.parentState;
            }
        }
        return result;
    }

    SymbolicBooleanConstraint getBooleanConstraint(SymbolicValue.SymbolicVariableValue variable) {
        switch (this.getRelation(variable, SymbolicValue.BOOLEAN_TRUE)) {
            case EQUAL_TO: {
                return SymbolicBooleanConstraint.TRUE;
            }
            case NOT_EQUAL: {
                return SymbolicBooleanConstraint.FALSE;
            }
        }
        return SymbolicBooleanConstraint.UNKNOWN;
    }

    ExecutionState setBooleanConstraint(SymbolicValue.SymbolicVariableValue variable, SymbolicBooleanConstraint constraint) {
        switch (constraint) {
            case FALSE: {
                this.setRelation(variable, SymbolicRelation.NOT_EQUAL, SymbolicValue.BOOLEAN_TRUE);
                break;
            }
            case TRUE: {
                this.setRelation(variable, SymbolicRelation.EQUAL_TO, SymbolicValue.BOOLEAN_TRUE);
                break;
            }
            default: {
                this.setRelation(variable, SymbolicRelation.UNKNOWN, SymbolicValue.BOOLEAN_TRUE);
            }
        }
        return this;
    }

    void invalidateRelationsOnValue(SymbolicValue value) {
        HashMultimap pairs = HashMultimap.create();
        ExecutionState current = this;
        while (current != null) {
            pairs.putAll((Object)value, current.findRelatedValues(value));
            current = current.parentState;
        }
        for (Map.Entry entry : pairs.entries()) {
            this.setRelation((SymbolicValue)entry.getKey(), SymbolicRelation.UNKNOWN, (SymbolicValue)entry.getValue());
        }
    }

    private Set<SymbolicValue> findRelatedValues(SymbolicValue value) {
        Map map = (Map)this.relations.rowMap().get(value);
        return map != null ? map.keySet() : ImmutableSet.of();
    }

    void invalidateFields() {
        ExecutionState state = this;
        while (state != null) {
            for (Map.Entry entry : state.relations.rowMap().entrySet()) {
                if (!ExecutionState.isField((SymbolicValue)entry.getKey())) continue;
                for (SymbolicValue other : ((Map)entry.getValue()).keySet()) {
                    this.setRelation((SymbolicValue)entry.getKey(), SymbolicRelation.UNKNOWN, other);
                }
            }
            state = state.parentState;
        }
    }

    private static boolean isField(SymbolicValue value) {
        return value instanceof SymbolicValue.SymbolicVariableValue && ((SymbolicValue.SymbolicVariableValue)value).variable.owner().isTypeSymbol();
    }

    static {
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.EQUAL_TO, (Object)SymbolicRelation.EQUAL_TO, (Object)SymbolicBooleanConstraint.TRUE);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.EQUAL_TO, (Object)SymbolicRelation.GREATER_EQUAL, (Object)SymbolicBooleanConstraint.TRUE);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.EQUAL_TO, (Object)SymbolicRelation.GREATER_THAN, (Object)SymbolicBooleanConstraint.FALSE);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.EQUAL_TO, (Object)SymbolicRelation.LESS_EQUAL, (Object)SymbolicBooleanConstraint.TRUE);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.EQUAL_TO, (Object)SymbolicRelation.LESS_THAN, (Object)SymbolicBooleanConstraint.FALSE);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.EQUAL_TO, (Object)SymbolicRelation.NOT_EQUAL, (Object)SymbolicBooleanConstraint.FALSE);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.EQUAL_TO, (Object)SymbolicRelation.UNKNOWN, (Object)SymbolicBooleanConstraint.UNKNOWN);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.GREATER_EQUAL, (Object)SymbolicRelation.EQUAL_TO, (Object)SymbolicBooleanConstraint.UNKNOWN);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.GREATER_EQUAL, (Object)SymbolicRelation.GREATER_EQUAL, (Object)SymbolicBooleanConstraint.TRUE);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.GREATER_EQUAL, (Object)SymbolicRelation.GREATER_THAN, (Object)SymbolicBooleanConstraint.UNKNOWN);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.GREATER_EQUAL, (Object)SymbolicRelation.LESS_EQUAL, (Object)SymbolicBooleanConstraint.UNKNOWN);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.GREATER_EQUAL, (Object)SymbolicRelation.LESS_THAN, (Object)SymbolicBooleanConstraint.FALSE);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.GREATER_EQUAL, (Object)SymbolicRelation.NOT_EQUAL, (Object)SymbolicBooleanConstraint.UNKNOWN);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.GREATER_EQUAL, (Object)SymbolicRelation.UNKNOWN, (Object)SymbolicBooleanConstraint.UNKNOWN);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.GREATER_THAN, (Object)SymbolicRelation.EQUAL_TO, (Object)SymbolicBooleanConstraint.FALSE);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.GREATER_THAN, (Object)SymbolicRelation.GREATER_EQUAL, (Object)SymbolicBooleanConstraint.TRUE);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.GREATER_THAN, (Object)SymbolicRelation.GREATER_THAN, (Object)SymbolicBooleanConstraint.TRUE);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.GREATER_THAN, (Object)SymbolicRelation.LESS_EQUAL, (Object)SymbolicBooleanConstraint.FALSE);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.GREATER_THAN, (Object)SymbolicRelation.LESS_THAN, (Object)SymbolicBooleanConstraint.FALSE);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.GREATER_THAN, (Object)SymbolicRelation.NOT_EQUAL, (Object)SymbolicBooleanConstraint.TRUE);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.GREATER_THAN, (Object)SymbolicRelation.UNKNOWN, (Object)SymbolicBooleanConstraint.UNKNOWN);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.LESS_EQUAL, (Object)SymbolicRelation.EQUAL_TO, (Object)SymbolicBooleanConstraint.UNKNOWN);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.LESS_EQUAL, (Object)SymbolicRelation.GREATER_EQUAL, (Object)SymbolicBooleanConstraint.UNKNOWN);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.LESS_EQUAL, (Object)SymbolicRelation.GREATER_THAN, (Object)SymbolicBooleanConstraint.FALSE);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.LESS_EQUAL, (Object)SymbolicRelation.LESS_EQUAL, (Object)SymbolicBooleanConstraint.TRUE);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.LESS_EQUAL, (Object)SymbolicRelation.LESS_THAN, (Object)SymbolicBooleanConstraint.UNKNOWN);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.LESS_EQUAL, (Object)SymbolicRelation.NOT_EQUAL, (Object)SymbolicBooleanConstraint.UNKNOWN);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.LESS_EQUAL, (Object)SymbolicRelation.UNKNOWN, (Object)SymbolicBooleanConstraint.UNKNOWN);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.LESS_THAN, (Object)SymbolicRelation.EQUAL_TO, (Object)SymbolicBooleanConstraint.FALSE);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.LESS_THAN, (Object)SymbolicRelation.GREATER_EQUAL, (Object)SymbolicBooleanConstraint.FALSE);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.LESS_THAN, (Object)SymbolicRelation.GREATER_THAN, (Object)SymbolicBooleanConstraint.FALSE);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.LESS_THAN, (Object)SymbolicRelation.LESS_EQUAL, (Object)SymbolicBooleanConstraint.TRUE);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.LESS_THAN, (Object)SymbolicRelation.LESS_THAN, (Object)SymbolicBooleanConstraint.TRUE);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.LESS_THAN, (Object)SymbolicRelation.NOT_EQUAL, (Object)SymbolicBooleanConstraint.TRUE);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.LESS_THAN, (Object)SymbolicRelation.UNKNOWN, (Object)SymbolicBooleanConstraint.UNKNOWN);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.NOT_EQUAL, (Object)SymbolicRelation.EQUAL_TO, (Object)SymbolicBooleanConstraint.FALSE);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.NOT_EQUAL, (Object)SymbolicRelation.GREATER_EQUAL, (Object)SymbolicBooleanConstraint.UNKNOWN);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.NOT_EQUAL, (Object)SymbolicRelation.GREATER_THAN, (Object)SymbolicBooleanConstraint.UNKNOWN);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.NOT_EQUAL, (Object)SymbolicRelation.LESS_EQUAL, (Object)SymbolicBooleanConstraint.UNKNOWN);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.NOT_EQUAL, (Object)SymbolicRelation.LESS_THAN, (Object)SymbolicBooleanConstraint.UNKNOWN);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.NOT_EQUAL, (Object)SymbolicRelation.NOT_EQUAL, (Object)SymbolicBooleanConstraint.TRUE);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.NOT_EQUAL, (Object)SymbolicRelation.UNKNOWN, (Object)SymbolicBooleanConstraint.UNKNOWN);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.UNKNOWN, (Object)SymbolicRelation.EQUAL_TO, (Object)SymbolicBooleanConstraint.UNKNOWN);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.UNKNOWN, (Object)SymbolicRelation.GREATER_EQUAL, (Object)SymbolicBooleanConstraint.UNKNOWN);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.UNKNOWN, (Object)SymbolicRelation.GREATER_THAN, (Object)SymbolicBooleanConstraint.UNKNOWN);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.UNKNOWN, (Object)SymbolicRelation.LESS_EQUAL, (Object)SymbolicBooleanConstraint.UNKNOWN);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.UNKNOWN, (Object)SymbolicRelation.LESS_THAN, (Object)SymbolicBooleanConstraint.UNKNOWN);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.UNKNOWN, (Object)SymbolicRelation.NOT_EQUAL, (Object)SymbolicBooleanConstraint.UNKNOWN);
        RELATION_RELATION_MAP.put((Object)SymbolicRelation.UNKNOWN, (Object)SymbolicRelation.UNKNOWN, (Object)SymbolicBooleanConstraint.UNKNOWN);
    }
}

