/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1258", name="Classes and enums with private members should have a constructor", priority=Priority.MAJOR, tags={"pitfall"})
@SqaleSubCharacteristic(value="RESOURCE_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class AtLeastOneConstructorCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS, (Object)Tree.Kind.ENUM);
    }

    public void visitNode(Tree tree) {
        ClassTree node = (ClassTree)tree;
        if (node.simpleName() != null && !ModifiersUtils.hasModifier((ModifiersTree)((ClassTree)tree).modifiers(), (Modifier)Modifier.ABSTRACT)) {
            List members = node.members();
            boolean hasPrivateMember = false;
            for (Tree member : members) {
                if (member.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR})) {
                    return;
                }
                if (!member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) continue;
                VariableTree variable = (VariableTree)member;
                Symbol symbol = variable.symbol();
                hasPrivateMember |= variable.initializer() == null && symbol.isPrivate() && !symbol.isStatic();
            }
            if (hasPrivateMember) {
                this.addIssue(tree, "Add a constructor to the " + node.declarationKeyword().text() + ".");
            }
        }
    }
}

