/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.AbstractBadFieldNameChecker;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S00116", name="Field names should comply with a naming convention", priority=Priority.MINOR, tags={"convention"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="2min")
public class BadFieldName_S00116_Check
extends AbstractBadFieldNameChecker {
    @RuleProperty(key="format", description="Regular expression used to check the field names against.", defaultValue="^[a-z][a-zA-Z0-9]*$")
    public String format = "^[a-z][a-zA-Z0-9]*$";

    @Override
    protected String getFormat() {
        return this.format;
    }

    @Override
    protected boolean isFieldModifierConcernedByRule(ModifiersTree modifier) {
        return !ModifiersUtils.hasModifier((ModifiersTree)modifier, (Modifier)Modifier.STATIC);
    }
}

