/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.checks.helpers.MethodsHelper;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="CallToDeprecatedMethod", name="Deprecated methods should not be used", priority=Priority.MINOR, tags={"cwe", "obsolete", "owasp-a9", "security"})
@SqaleSubCharacteristic(value="SOFTWARE_RELATED_PORTABILITY")
@SqaleConstantRemediation(value="15min")
public class CallToDeprecatedMethodCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD_INVOCATION, (Object)Tree.Kind.NEW_CLASS);
    }

    public void visitNode(Tree tree) {
        Symbol symbol = tree.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS}) ? ((NewClassTree)tree).constructorSymbol() : ((MethodInvocationTree)tree).symbol();
        if (symbol.metadata().isAnnotatedWith("java.lang.Deprecated")) {
            String name = symbol.name();
            String message = "<init>".equals(name) ? "Constructor '" + symbol.owner().name() + "(...)' is deprecated." : "Method '" + symbol.owner().name() + "." + name + "(...)' is deprecated.";
            Object reported = tree.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS}) ? ((NewClassTree)tree).identifier() : MethodsHelper.methodName((MethodInvocationTree)tree);
            this.reportIssue((Tree)reported, message);
        }
    }
}

