/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.apache.commons.lang.StringUtils;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;

public class CommentContainsPatternChecker {
    private final SubscriptionBaseVisitor newCheck;
    private final String pattern;
    private final String message;

    public CommentContainsPatternChecker(SubscriptionBaseVisitor check, String pattern, String message) {
        this.newCheck = check;
        this.pattern = pattern;
        this.message = message;
    }

    private static boolean isLetterAround(String line, String pattern) {
        int start = StringUtils.indexOfIgnoreCase((String)line, (String)pattern);
        int end = start + pattern.length();
        boolean pre = start > 0 && Character.isLetter(line.charAt(start - 1));
        boolean post = end < line.length() - 1 && Character.isLetter(line.charAt(end));
        return pre || post;
    }

    public void checkTrivia(SyntaxTrivia syntaxTrivia) {
        String comment = syntaxTrivia.comment();
        if (StringUtils.containsIgnoreCase((String)comment, (String)this.pattern)) {
            String[] lines = comment.split("\r\n?|\n");
            for (int i = 0; i < lines.length; ++i) {
                if (!StringUtils.containsIgnoreCase((String)lines[i], (String)this.pattern) || CommentContainsPatternChecker.isLetterAround(lines[i], this.pattern)) continue;
                this.newCheck.addIssue(syntaxTrivia.startLine() + i, this.message);
            }
        }
    }
}

