/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.checks.helpers.JavaVersionHelper;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.ArrayTypeTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2293", name="The diamond operator (\"<>\") should be used", priority=Priority.MAJOR, tags={"java7", "clumsy"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="5min")
public class DiamondOperatorCheck
extends SubscriptionBaseVisitor
implements JavaVersionAwareVisitor {
    public boolean isCompatibleWithJavaVersion(@Nullable Integer version) {
        return JavaVersionHelper.java7Compatible(version);
    }

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.NEW_CLASS);
    }

    public void visitNode(Tree tree) {
        TypeTree type;
        NewClassTree newClassTree = (NewClassTree)tree;
        TypeTree newTypeTree = newClassTree.identifier();
        if (newClassTree.classBody() == null && DiamondOperatorCheck.isParameterizedType(newTypeTree) && (type = DiamondOperatorCheck.getTypeFromExpression(tree.parent())) != null && DiamondOperatorCheck.isParameterizedType(type)) {
            this.reportIssue((Tree)((ParameterizedTypeTree)newTypeTree).typeArguments(), "Replace the type specification in this constructor call with the diamond operator (\"<>\")." + JavaVersionHelper.java7CompatibilityMessage(this.context.getJavaVersion()));
        }
    }

    @CheckForNull
    private static TypeTree getTypeFromExpression(Tree expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.VARIABLE, Tree.Kind.TYPE_CAST, Tree.Kind.RETURN_STATEMENT, Tree.Kind.ASSIGNMENT, Tree.Kind.CONDITIONAL_EXPRESSION})) {
            TypeTreeLocator visitor = new TypeTreeLocator();
            expression.accept((TreeVisitor)visitor);
            return visitor.type;
        }
        return null;
    }

    private static boolean isParameterizedType(TypeTree type) {
        if (type.is(new Tree.Kind[]{Tree.Kind.ARRAY_TYPE})) {
            return DiamondOperatorCheck.isParameterizedType(((ArrayTypeTree)type).type());
        }
        return type.is(new Tree.Kind[]{Tree.Kind.PARAMETERIZED_TYPE}) && !((ParameterizedTypeTree)type).typeArguments().isEmpty();
    }

    private static class TypeTreeLocator
    extends BaseTreeVisitor {
        private TypeTree type = null;

        private TypeTreeLocator() {
        }

        public void visitReturnStatement(ReturnStatementTree tree) {
            this.type = TypeTreeLocator.getMethodReturnType(tree);
        }

        public void visitTypeCast(TypeCastTree tree) {
            this.type = tree.type();
        }

        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            Tree assignedVariable = TypeTreeLocator.getAssignedVariable(tree.variable());
            if (assignedVariable != null) {
                this.type = DiamondOperatorCheck.getTypeFromExpression(assignedVariable);
            }
        }

        public void visitVariable(VariableTree tree) {
            this.type = tree.type();
        }

        public void visitConditionalExpression(ConditionalExpressionTree tree) {
            this.type = DiamondOperatorCheck.getTypeFromExpression(tree.parent());
        }

        private static TypeTree getMethodReturnType(ReturnStatementTree returnStatementTree) {
            MethodTree methodTree = TypeTreeLocator.getParentMethod((Tree)returnStatementTree);
            return methodTree.returnType();
        }

        private static MethodTree getParentMethod(Tree tree) {
            Tree result = tree;
            while (!result.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
                result = result.parent();
            }
            return (MethodTree)result;
        }

        @CheckForNull
        private static Tree getAssignedVariable(ExpressionTree expression) {
            if (expression.is(new Tree.Kind[]{Tree.Kind.ARRAY_ACCESS_EXPRESSION})) {
                return TypeTreeLocator.getAssignedVariable(((ArrayAccessExpressionTree)expression).expression());
            }
            IdentifierTree identifier = expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) ? (IdentifierTree)expression : ((MemberSelectExpressionTree)expression).identifier();
            return identifier.symbol().declaration();
        }
    }
}

