/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2094", name="Classes should not be empty", priority=Priority.MAJOR, tags={"clumsy"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class EmptyClassCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        if (EmptyClassCheck.isEmptyClass((ClassTree)tree)) {
            this.addIssue(tree, "Remove this empty class, write its code or make it an \"interface\".");
        }
    }

    private static boolean isEmptyClass(ClassTree tree) {
        return tree.simpleName() != null && EmptyClassCheck.isNotExtending(tree) && EmptyClassCheck.isEmpty(tree);
    }

    private static boolean isNotExtending(ClassTree tree) {
        return tree.superClass() == null && tree.superInterfaces().isEmpty();
    }

    private static boolean isEmpty(ClassTree tree) {
        for (Tree member : tree.members()) {
            if (member.is(new Tree.Kind[]{Tree.Kind.EMPTY_STATEMENT})) continue;
            return false;
        }
        return true;
    }
}

