/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Deque;
import java.util.LinkedList;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2694", name="Inner classes which do not reference their owning classes should be \"static\"", priority=Priority.MAJOR, tags={"performance"})
@SqaleSubCharacteristic(value="MEMORY_EFFICIENCY")
@SqaleConstantRemediation(value="15min")
public class InnerStaticClassesCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;
    private Deque<Symbol> outerClasses = new LinkedList<Symbol>();
    private Deque<Boolean> atLeastOneReference = new LinkedList<Boolean>();

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitClass(ClassTree tree) {
        Symbol.TypeSymbol symbol = tree.symbol();
        if (!tree.is(new Tree.Kind[]{Tree.Kind.CLASS})) {
            return;
        }
        this.outerClasses.push((Symbol)symbol);
        this.atLeastOneReference.push(Boolean.FALSE);
        this.scan(tree.members());
        Boolean oneReference = this.atLeastOneReference.pop();
        this.outerClasses.pop();
        if (!symbol.isStatic() && !oneReference.booleanValue() && !this.outerClasses.isEmpty() && InnerStaticClassesCheck.isFirstParentStatic(this.outerClasses)) {
            String named = symbol.name().isEmpty() ? "named " : "";
            this.context.addIssue((Tree)tree, (JavaCheck)this, "Make this a " + named + "\"static\" inner class.");
        }
    }

    private static boolean isFirstParentStatic(Deque<Symbol> outerClasses) {
        if (outerClasses.size() == 1) {
            return true;
        }
        for (Symbol outerClass : outerClasses) {
            if (!outerClass.isStatic()) continue;
            return true;
        }
        return false;
    }

    public void visitIdentifier(IdentifierTree tree) {
        super.visitIdentifier(tree);
        this.checkSymbol(tree.symbol());
    }

    public void visitNewClass(NewClassTree tree) {
        super.visitNewClass(tree);
        this.checkSymbol((Symbol)tree.symbolType().symbol());
    }

    private void checkSymbol(Symbol symbol) {
        int level;
        if (!this.atLeastOneReference.isEmpty() && (level = this.referenceInstance(symbol)) >= 0) {
            for (int i = 0; i < level; ++i) {
                this.atLeastOneReference.pop();
            }
            while (this.atLeastOneReference.size() != this.outerClasses.size()) {
                this.atLeastOneReference.push(Boolean.TRUE);
            }
        }
    }

    private int referenceInstance(Symbol symbol) {
        Symbol owner = symbol.owner();
        if (owner != null && owner.isMethodSymbol()) {
            owner = owner.owner();
        }
        int result = -1;
        if (owner != null && !this.outerClasses.peek().equals(owner)) {
            if (symbol.isUnknown()) {
                result = this.atLeastOneReference.size() - 1;
            } else if (!symbol.isStatic()) {
                result = this.fromInstance(owner);
            }
        }
        return result;
    }

    private int fromInstance(Symbol owner) {
        int i = -1;
        Type ownerType = owner.type();
        for (Symbol outerClass : this.outerClasses) {
            ++i;
            if (!owner.equals(outerClass) && (ownerType == null || !owner.isTypeSymbol() || !outerClass.type().isSubtypeOf(ownerType))) continue;
            return i;
        }
        return -1;
    }

    public void visitVariable(VariableTree tree) {
        Symbol symbol = tree.symbol();
        if (symbol != null && !symbol.isStatic()) {
            super.visitVariable(tree);
        }
    }
}

