/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2176", name="Class names should not shadow interfaces or superclasses", priority=Priority.MAJOR, tags={"pitfall"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class InterfaceOrSuperclassShadowingCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS, (Object)Tree.Kind.INTERFACE);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (this.hasSemantic()) {
            Symbol.TypeSymbol classSymbol = classTree.symbol();
            this.checkSuperType(classTree, classSymbol.superClass());
            for (Type interfaceType : classSymbol.interfaces()) {
                this.checkSuperType(classTree, interfaceType);
            }
        }
    }

    private void checkSuperType(ClassTree tree, Type superType) {
        if (superType != null && superType.symbol().name().equals(tree.symbol().name())) {
            String classOrInterface = tree.is(new Tree.Kind[]{Tree.Kind.CLASS}) ? "class" : "interface";
            this.addIssue((Tree)tree, "Rename this " + classOrInterface + ".");
        }
    }
}

