/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2187", name="TestCases should contain tests", priority=Priority.MAJOR, tags={"junit", "unused"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNIT_TESTABILITY")
@SqaleConstantRemediation(value="5min")
public class NoTestInTestClassCheck
extends SubscriptionBaseVisitor {
    private static final Predicate<SymbolMetadata.AnnotationInstance> PREDICATE_ANNOTATION_TEST_OR_UNKNOWN = new Predicate<SymbolMetadata.AnnotationInstance>(){

        public boolean apply(SymbolMetadata.AnnotationInstance input) {
            Type type = input.symbol().type();
            return type.isUnknown() || type.is("org.junit.Test") || type.is("org.testng.annotations.Test");
        }
    };

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.COMPILATION_UNIT);
    }

    public void visitNode(Tree tree) {
        CompilationUnitTree cut = (CompilationUnitTree)tree;
        for (Tree typeTree : cut.types()) {
            ClassTree classTree;
            if (!typeTree.is(new Tree.Kind[]{Tree.Kind.CLASS}) || ModifiersUtils.hasModifier((ModifiersTree)(classTree = (ClassTree)typeTree).modifiers(), (Modifier)Modifier.ABSTRACT)) continue;
            this.checkJunit3TestClass(classTree);
            this.checkJunit4TestClass(classTree);
        }
    }

    private void checkJunit3TestClass(ClassTree tree) {
        if (tree.symbol().type().isSubtypeOf("junit.framework.TestCase")) {
            this.checkMethods(tree, false);
        }
    }

    private void checkJunit4TestClass(ClassTree tree) {
        IdentifierTree name = tree.simpleName();
        if (name != null && name.name().endsWith("Test")) {
            this.checkMethods(tree, true);
        }
    }

    private void checkMethods(ClassTree classTree, boolean forJunit4) {
        for (Tree member : classTree.members()) {
            if (!member.is(new Tree.Kind[]{Tree.Kind.METHOD}) || !NoTestInTestClassCheck.isTestMethod(forJunit4, (MethodTree)member)) continue;
            return;
        }
        this.addIssue((Tree)classTree, "Add some tests to this class.");
    }

    private static boolean isTestMethod(boolean forJunit4, MethodTree member) {
        if (forJunit4) {
            return Iterables.any((Iterable)member.symbol().metadata().annotations(), PREDICATE_ANNOTATION_TEST_OR_UNKNOWN);
        }
        return member.simpleName().name().startsWith("test");
    }
}

