/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.JavaVersionAwareVisitor;
import org.sonar.java.checks.helpers.JavaVersionHelper;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1612", name="Lambdas should be replaced with method references", priority=Priority.MINOR, tags={"java8"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="2min")
public class ReplaceLambdaByMethodRefCheck
extends BaseTreeVisitor
implements JavaFileScanner,
JavaVersionAwareVisitor {
    private JavaFileScannerContext context;

    public boolean isCompatibleWithJavaVersion(@Nullable Integer version) {
        return JavaVersionHelper.java8Compatible(version);
    }

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitLambdaExpression(LambdaExpressionTree tree) {
        if (ReplaceLambdaByMethodRefCheck.isSingleMethodInvocationUsingLambdaParamAsArg(tree) || ReplaceLambdaByMethodRefCheck.isBlockInvokingMethod(tree.body())) {
            this.context.addIssue((Tree)tree, (JavaCheck)this, "Replace this lambda with a method reference." + JavaVersionHelper.java8CompatibilityMessage(this.context.getJavaVersion()));
        }
        super.visitLambdaExpression(tree);
    }

    private static boolean isSingleMethodInvocationUsingLambdaParamAsArg(LambdaExpressionTree tree) {
        List parameters = tree.parameters();
        Tree body = tree.body();
        if (parameters.size() == 1 && body.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            List usages = ((VariableTree)parameters.get(0)).symbol().usages();
            Arguments arguments = ((MethodInvocationTree)body).arguments();
            return usages.size() == 1 && arguments.size() == 1 && ((IdentifierTree)usages.get(0)).equals(arguments.get(0));
        }
        return false;
    }

    private static boolean isBlockInvokingMethod(Tree tree) {
        if (ReplaceLambdaByMethodRefCheck.isBlockWithOneStatement(tree)) {
            Tree statement = (Tree)((BlockTree)tree).body().get(0);
            return ReplaceLambdaByMethodRefCheck.isExpressionStatementInvokingMethod(statement) || ReplaceLambdaByMethodRefCheck.isReturnStatementInvokingMethod(statement);
        }
        return false;
    }

    private static boolean isBlockWithOneStatement(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.BLOCK}) && ((BlockTree)tree).body().size() == 1;
    }

    private static boolean isExpressionStatementInvokingMethod(Tree statement) {
        return statement.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT}) && ReplaceLambdaByMethodRefCheck.isMethodInvocation((Tree)((ExpressionStatementTree)statement).expression());
    }

    private static boolean isReturnStatementInvokingMethod(Tree statement) {
        return statement.is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT}) && ReplaceLambdaByMethodRefCheck.isMethodInvocation((Tree)((ReturnStatementTree)statement).expression());
    }

    private static boolean isMethodInvocation(@Nullable Tree tree) {
        return tree != null && tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION});
    }
}

