/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.SyntacticEquivalence;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1656", name="Variables should not be self-assigned", priority=Priority.MAJOR, tags={"bug", "cert"})
@SqaleSubCharacteristic(value="DATA_RELIABILITY")
@SqaleConstantRemediation(value="3min")
public class SelfAssignementCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.ASSIGNMENT);
    }

    public void visitNode(Tree tree) {
        AssignmentExpressionTree node = (AssignmentExpressionTree)tree;
        if (SyntacticEquivalence.areEquivalent((Tree)node.expression(), (Tree)node.variable())) {
            this.addIssue(tree, "Remove or correct this useless self-assignment.");
        }
    }
}

