/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayDeque;
import java.util.Deque;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BreakStatementTree;
import org.sonar.plugins.java.api.tree.ContinueStatementTree;
import org.sonar.plugins.java.api.tree.DoWhileStatementTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleLinearRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S135", name="Loops should not contain more than a single \"break\" or \"continue\" statement", priority=Priority.MAJOR, tags={"brain-overload"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleLinearRemediation(coeff="20min", effortToFixDescription="per extra \"break\" or \"continue\" statement")
public class SeveralBreakOrContinuePerLoopCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private final Deque<Integer> breakAndContinueCounter = new ArrayDeque<Integer>();
    private final Deque<Boolean> currentScopeIsSwitch = new ArrayDeque<Boolean>();
    private int loopCount;
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.loopCount = 0;
        this.scan((Tree)context.getTree());
    }

    public void visitForStatement(ForStatementTree tree) {
        this.enterLoop();
        super.visitForStatement(tree);
        this.leaveLoop((Tree)tree);
    }

    public void visitForEachStatement(ForEachStatement tree) {
        this.enterLoop();
        super.visitForEachStatement(tree);
        this.leaveLoop((Tree)tree);
    }

    public void visitWhileStatement(WhileStatementTree tree) {
        this.enterLoop();
        super.visitWhileStatement(tree);
        this.leaveLoop((Tree)tree);
    }

    public void visitDoWhileStatement(DoWhileStatementTree tree) {
        this.enterLoop();
        super.visitDoWhileStatement(tree);
        this.leaveLoop((Tree)tree);
    }

    public void visitBreakStatement(BreakStatementTree tree) {
        if (this.isInLoop() && !this.isInSwitch()) {
            this.incrementBreakCounter();
        }
        super.visitBreakStatement(tree);
    }

    public void visitContinueStatement(ContinueStatementTree tree) {
        if (this.isInLoop()) {
            this.incrementBreakCounter();
        }
        super.visitContinueStatement(tree);
    }

    private boolean isInLoop() {
        return this.loopCount > 0;
    }

    private boolean isInSwitch() {
        return this.currentScopeIsSwitch.peek();
    }

    private void incrementBreakCounter() {
        int increment = 1;
        if (!this.breakAndContinueCounter.isEmpty()) {
            increment += this.breakAndContinueCounter.pop().intValue();
        }
        this.breakAndContinueCounter.push(increment);
    }

    public void visitSwitchStatement(SwitchStatementTree tree) {
        this.currentScopeIsSwitch.push(true);
        super.visitSwitchStatement(tree);
        this.currentScopeIsSwitch.pop();
    }

    private void enterLoop() {
        ++this.loopCount;
        this.breakAndContinueCounter.push(0);
        this.currentScopeIsSwitch.push(false);
    }

    private void leaveLoop(Tree tree) {
        int count = 0;
        if (!this.breakAndContinueCounter.isEmpty()) {
            count = this.breakAndContinueCounter.pop();
        }
        if (count > 1) {
            double effortToFix = (double)count - 1.0;
            this.context.addIssue(tree, (JavaCheck)this, "Reduce the total number of break and continue statements in this loop to use at most one.", Double.valueOf(effortToFix));
        }
        --this.loopCount;
        this.currentScopeIsSwitch.pop();
    }
}

