/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.regex.Pattern;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S00118", name="Abstract class names should comply with a naming convention", priority=Priority.MINOR, tags={"convention"})
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="10min")
public class BadAbstractClassName_S00118_Check
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String DEFAULT_FORMAT = "^Abstract[A-Z][a-zA-Z0-9]*$";
    @RuleProperty(key="format", description="Regular expression used to check the abstract class names against.", defaultValue="^Abstract[A-Z][a-zA-Z0-9]*$")
    public String format = "^Abstract[A-Z][a-zA-Z0-9]*$";
    private Pattern pattern = null;
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.format, 32);
        }
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitClass(ClassTree tree) {
        IdentifierTree simpleName = tree.simpleName();
        if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS}) && simpleName != null) {
            if (this.pattern.matcher(simpleName.name()).matches()) {
                if (!BadAbstractClassName_S00118_Check.isAbstract(tree)) {
                    this.context.reportIssue((JavaCheck)this, (Tree)simpleName, "Make this class abstract or rename it, since it matches the regular expression '" + this.format + "'.");
                }
            } else if (BadAbstractClassName_S00118_Check.isAbstract(tree)) {
                this.context.reportIssue((JavaCheck)this, (Tree)simpleName, "Rename this abstract class name to match the regular expression '" + this.format + "'.");
            }
        }
        super.visitClass(tree);
    }

    private static boolean isAbstract(ClassTree tree) {
        return ModifiersUtils.hasModifier((ModifiersTree)tree.modifiers(), (Modifier)Modifier.ABSTRACT);
    }
}

