/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.checks.methods.MethodMatcher;
import org.sonar.java.checks.methods.TypeCriteria;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2658", name="Classes should not be loaded dynamically", priority=Priority.CRITICAL, tags={"cwe", "owasp-a1", "security"})
@SqaleSubCharacteristic(value="API_ABUSE")
@SqaleConstantRemediation(value="45min")
public class DynamicClassLoadCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf("java.lang.Class")).name("forName").withNoParameterConstraint(), (Object)MethodMatcher.create().typeDefinition(TypeCriteria.subtypeOf("java.lang.ClassLoader")).name("loadClass").withNoParameterConstraint());
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        this.addIssue((Tree)mit, "Remove this use of dynamic class loading.");
    }
}

