/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.checks.methods.MethodMatcher;
import org.sonar.java.checks.methods.TypeCriteria;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2204", name="\".equals()\" should not be used to test the values of \"Atomic\" classes", priority=Priority.BLOCKER, tags={"bug"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="DATA_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class EqualsOnAtomicClassCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)EqualsOnAtomicClassCheck.equalsInvocationMatcher("java.util.concurrent.atomic.AtomicBoolean"), (Object)EqualsOnAtomicClassCheck.equalsInvocationMatcher("java.util.concurrent.atomic.AtomicInteger"), (Object)EqualsOnAtomicClassCheck.equalsInvocationMatcher("java.util.concurrent.atomic.AtomicLong"));
    }

    private static MethodMatcher equalsInvocationMatcher(String fullyQualifiedName) {
        return MethodMatcher.create().callSite(TypeCriteria.is(fullyQualifiedName)).name("equals").addParameter("java.lang.Object");
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        this.addIssue((Tree)mit, "Use \".get()\" to retrieve the value and compare it instead.");
        super.onMethodInvocationFound(mit);
    }
}

