/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1145", name="Useless \"if(true) {...}\" and \"if(false){...}\" blocks should be removed", priority=Priority.MAJOR, status="DEPRECATED", tags={"cwe", "misra"})
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="2min")
public class IfConditionAlwaysTrueOrFalseCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.IF_STATEMENT);
    }

    public void visitNode(Tree tree) {
        if (((IfStatementTree)tree).condition().is(new Tree.Kind[]{Tree.Kind.BOOLEAN_LITERAL})) {
            this.addIssue(tree, "Remove this if statement.");
        }
    }
}

