/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.checks.methods.MethodMatcher;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2232", name="\"ResultSet.isLast()\" should not be used", priority=Priority.MAJOR, tags={"performance", "pitfall", "sql"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="10min")
public class ResultSetIsLastCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)MethodMatcher.create().typeDefinition("java.sql.ResultSet").name("isLast"));
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        this.addIssue((Tree)mit, "Remove this call to \"isLast()\".");
    }
}

