/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2226", name="Servlets should not have mutable instance fields", priority=Priority.CRITICAL, tags={"bug", "cert", "multi-threading", "struts"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="SYNCHRONIZATION_RELIABILITY")
@SqaleConstantRemediation(value="30min")
public class ServletInstanceFieldCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.VARIABLE);
    }

    public void visitNode(Tree tree) {
        VariableTree variable = (VariableTree)tree;
        if (this.hasSemantic() && ServletInstanceFieldCheck.isOwnedByAServlet(variable) && !ServletInstanceFieldCheck.isStaticOrFinal(variable)) {
            this.addIssue(tree, "Remove this misleading mutable servlet instance fields or make it \"static\" and/or \"final\"");
        }
    }

    private static boolean isOwnedByAServlet(VariableTree variable) {
        Symbol owner = variable.symbol().owner();
        return owner.isTypeSymbol() && (owner.type().isSubtypeOf("javax.servlet.http.HttpServlet") || owner.type().isSubtypeOf("org.apache.struts.action.Action"));
    }

    private static boolean isStaticOrFinal(VariableTree variable) {
        ModifiersTree modifiers = variable.modifiers();
        return ModifiersUtils.hasModifier((ModifiersTree)modifiers, (Modifier)Modifier.STATIC) || ModifiersUtils.hasModifier((ModifiersTree)modifiers, (Modifier)Modifier.FINAL);
    }
}

