/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1162", name="Checked Exception should not be thrown", priority=Priority.MAJOR, tags={"error-handling"})
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="1h")
public class ThrowCheckedExceptionCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.THROW_STATEMENT);
    }

    public void visitNode(Tree tree) {
        ThrowStatementTree throwStatementTree = (ThrowStatementTree)tree;
        Type symbolType = throwStatementTree.expression().symbolType();
        if (symbolType.isSubtypeOf("java.lang.Exception") && !symbolType.isSubtypeOf("java.lang.RuntimeException")) {
            this.addIssue(tree, "Remove the usage of the checked exception '" + symbolType.name() + "'.");
        }
    }
}

