/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1448", name="Classes should not have too many methods", priority=Priority.MAJOR, tags={"brain-overload"})
@SqaleSubCharacteristic(value="ARCHITECTURE_CHANGEABILITY")
@SqaleConstantRemediation(value="1h")
public class TooManyMethodsCheck
extends SubscriptionBaseVisitor {
    private static final int DEFAULT_MAXIMUM = 35;
    @RuleProperty(key="maximumMethodThreshold", description="The maximum number of methods authorized in a class.", defaultValue="35")
    public int maximumMethodThreshold = 35;
    @RuleProperty(key="countNonpublicMethods", description="Whether or not to include non-public methods in the count.", defaultValue="true")
    public boolean countNonPublic = true;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS, (Object)Tree.Kind.ENUM, (Object)Tree.Kind.INTERFACE, (Object)Tree.Kind.ANNOTATION_TYPE);
    }

    public void visitNode(Tree tree) {
        int count = 0;
        ClassTree classTree = (ClassTree)tree;
        for (Tree member : classTree.members()) {
            if (!member.is(new Tree.Kind[]{Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR}) || !this.countNonPublic && !((MethodTree)member).symbol().isPublic()) continue;
            ++count;
        }
        if (count > this.maximumMethodThreshold) {
            this.addIssue(tree, String.format("\"%s\" \"%s\" has %d%s methods, which is greater than the %d authorized. Split it into smaller classes.", classTree.declarationKeyword().text(), classTree.simpleName(), count, this.countNonPublic ? "" : " public", this.maximumMethodThreshold));
        }
    }
}

