/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.maven;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.maven.MavenCheck;
import org.sonar.maven.MavenFileScanner;
import org.sonar.maven.MavenFileScannerContext;
import org.sonar.maven.model.LocatedTree;
import org.sonar.maven.model.maven2.MavenProject;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S3423", name="pom elements should be in the recommended order", priority=Priority.MINOR, tags={"convention", "maven"})
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="10min")
public class PomElementOrderCheck
implements MavenFileScanner {
    private static final Comparator<LocatedTree> LINE_COMPARATOR = new LineComparator();

    public void scanFile(MavenFileScannerContext context) {
        MavenProject project = context.getMavenProject();
        List<MavenFileScannerContext.Location> issues = PomElementOrderCheck.checkPositions(new LocatedTree[]{project.getModelVersion(), project.getParent(), project.getGroupId(), project.getArtifactId(), project.getVersion(), project.getPackaging(), project.getName(), project.getUrl(), project.getInceptionYear(), project.getOrganization(), project.getLicenses(), project.getDevelopers(), project.getContributors(), project.getMailingLists(), project.getPrerequisites(), project.getModules(), project.getScm(), project.getIssueManagement(), project.getCiManagement(), project.getDistributionManagement(), project.getProperties(), project.getDependencyManagement(), project.getDependencies(), project.getRepositories(), project.getPluginRepositories(), project.getBuild(), project.getReporting(), project.getProfiles()});
        if (!issues.isEmpty()) {
            context.reportIssue((MavenCheck)this, project.startLocation().line(), "Reorder the elements of this pom to match the recommended order.", issues);
        }
    }

    private static List<MavenFileScannerContext.Location> checkPositions(LocatedTree ... trees) {
        LinkedList<MavenFileScannerContext.Location> issues = new LinkedList<MavenFileScannerContext.Location>();
        List<LocatedTree> expectedOrder = PomElementOrderCheck.getNonNullTrees(trees);
        List<LocatedTree> observedOrder = PomElementOrderCheck.sortByLine(expectedOrder);
        for (int index = 0; index < expectedOrder.size(); ++index) {
            LocatedTree expected = expectedOrder.get(index);
            int indexObserved = observedOrder.indexOf(expected);
            if (issues.isEmpty() && index == indexObserved) continue;
            issues.add(new MavenFileScannerContext.Location("Expected position: " + (index + 1), expected));
        }
        return issues;
    }

    private static List<LocatedTree> getNonNullTrees(LocatedTree ... trees) {
        LinkedList<LocatedTree> result = new LinkedList<LocatedTree>();
        for (LocatedTree locatedTree : trees) {
            if (locatedTree == null) continue;
            result.add(locatedTree);
        }
        return result;
    }

    private static List<LocatedTree> sortByLine(List<LocatedTree> expectedOrder) {
        LinkedList<LocatedTree> result = new LinkedList<LocatedTree>(expectedOrder);
        Collections.sort(result, LINE_COMPARATOR);
        return result;
    }

    private static class LineComparator
    implements Comparator<LocatedTree> {
        private LineComparator() {
        }

        @Override
        public int compare(LocatedTree o1, LocatedTree o2) {
            return Integer.compare(o1.startLocation().line(), o2.startLocation().line());
        }
    }
}

