/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.methods;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.sonar.java.checks.methods.MethodMatcher;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;

public class MethodInvocationMatcherCollection {
    private List<MethodMatcher> matchers = Lists.newLinkedList();

    private MethodInvocationMatcherCollection() {
    }

    public static MethodInvocationMatcherCollection create() {
        return new MethodInvocationMatcherCollection();
    }

    public static MethodInvocationMatcherCollection create(MethodMatcher ... matchers) {
        MethodInvocationMatcherCollection collection = new MethodInvocationMatcherCollection();
        Collections.addAll(collection.matchers, matchers);
        return collection;
    }

    public MethodInvocationMatcherCollection add(MethodMatcher matcher) {
        this.matchers.add(matcher);
        return this;
    }

    public boolean anyMatch(MethodInvocationTree mit) {
        for (MethodMatcher matcher : this.matchers) {
            if (!matcher.matches(mit)) continue;
            return true;
        }
        return false;
    }

    public boolean anyMatch(MethodTree method) {
        for (MethodMatcher matcher : this.matchers) {
            if (!matcher.matches(method)) continue;
            return true;
        }
        return false;
    }
}

