/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.java.matcher.MethodMatcherCollection;
import org.sonar.java.matcher.NameCriteria;
import org.sonar.java.matcher.TypeCriteria;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2699")
public class AssertionsInTestsCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String VERIFY = "verify";
    private static final String ORG_MOCKITO_MOCKITO = "org.mockito.Mockito";
    private static final TypeCriteria ANY_TYPE = TypeCriteria.anyType();
    private static final NameCriteria ANY_NAME = NameCriteria.any();
    private static final NameCriteria STARTS_WITH_FAIL = NameCriteria.startsWith((String)"fail");
    private static final MethodMatcher MOCKITO_VERIFY = AssertionsInTestsCheck.methodWithoutParameter("org.mockito.Mockito", "verify");
    private static final MethodMatcher ASSERTJ_ASSERT_ALL = AssertionsInTestsCheck.methodWithParameters("org.assertj.core.api.SoftAssertions", "assertAll");
    private static final MethodMatcher ASSERT_THAT = AssertionsInTestsCheck.methodWithParameters(ANY_TYPE, "assertThat").addParameter(ANY_TYPE);
    private static final MethodMatcher FEST_AS_METHOD = AssertionsInTestsCheck.methodWithoutParameter(ANY_TYPE, "as");
    private static final MethodMatcher FEST_DESCRIBED_AS_METHOD = AssertionsInTestsCheck.methodWithoutParameter(ANY_TYPE, "describedAs");
    private static final MethodMatcher FEST_OVERRIDE_ERROR_METHOD = AssertionsInTestsCheck.methodWithoutParameter(ANY_TYPE, "overridingErrorMessage");
    private static final MethodMatcherCollection ASSERTION_INVOCATION_MATCHERS = MethodMatcherCollection.create((MethodMatcher[])new MethodMatcher[]{AssertionsInTestsCheck.methodWithoutParameter("org.junit.Assert", NameCriteria.startsWith((String)"assert")), AssertionsInTestsCheck.methodWithoutParameter("org.junit.Assert", "fail"), AssertionsInTestsCheck.methodWithoutParameter("org.junit.rules.ExpectedException", NameCriteria.startsWith((String)"expect")), AssertionsInTestsCheck.methodWithoutParameter(TypeCriteria.subtypeOf((String)"junit.framework.Assert"), NameCriteria.startsWith((String)"assert")), AssertionsInTestsCheck.methodWithoutParameter(TypeCriteria.subtypeOf((String)"junit.framework.Assert"), STARTS_WITH_FAIL), AssertionsInTestsCheck.methodWithoutParameter(TypeCriteria.subtypeOf((String)"org.fest.assertions.GenericAssert"), ANY_NAME), AssertionsInTestsCheck.methodWithoutParameter("org.fest.assertions.Fail", STARTS_WITH_FAIL), AssertionsInTestsCheck.methodWithoutParameter(TypeCriteria.subtypeOf((String)"org.fest.assertions.api.AbstractAssert"), ANY_NAME), AssertionsInTestsCheck.methodWithoutParameter("org.fest.assertions.api.Fail", STARTS_WITH_FAIL), AssertionsInTestsCheck.methodWithoutParameter(TypeCriteria.subtypeOf((String)"org.assertj.core.api.AbstractAssert"), ANY_NAME), AssertionsInTestsCheck.methodWithoutParameter("org.assertj.core.api.Fail", STARTS_WITH_FAIL), AssertionsInTestsCheck.methodWithoutParameter("org.assertj.core.api.Fail", "shouldHaveThrown"), AssertionsInTestsCheck.methodWithoutParameter("org.assertj.core.api.Assertions", STARTS_WITH_FAIL), AssertionsInTestsCheck.methodWithoutParameter("org.assertj.core.api.Assertions", "shouldHaveThrown"), AssertionsInTestsCheck.methodWithParameters("org.hamcrest.MatcherAssert", "assertThat").addParameter(ANY_TYPE).addParameter(ANY_TYPE), AssertionsInTestsCheck.methodWithoutParameter("org.mockito.Mockito", "verifyNoMoreInteractions"), AssertionsInTestsCheck.methodWithoutParameter("org.mockito.Mockito", "verifyZeroInteractions"), AssertionsInTestsCheck.methodWithParameters("org.springframework.test.web.servlet.ResultActions", "andExpect").addParameter(ANY_TYPE), AssertionsInTestsCheck.methodWithoutParameter("org.easymock.EasyMock", "verify"), AssertionsInTestsCheck.methodWithoutParameter(TypeCriteria.subtypeOf((String)"org.easymock.IMocksControl"), "verify"), AssertionsInTestsCheck.methodWithoutParameter(TypeCriteria.subtypeOf((String)"org.easymock.EasyMockSupport"), "verifyAll")});
    private final Deque<Boolean> methodContainsAssertion = new ArrayDeque<Boolean>();
    private final Deque<Boolean> methodContainsAssertjSoftAssertionUsage = new ArrayDeque<Boolean>();
    private final Deque<Boolean> methodContainsJunitSoftAssertionUsage = new ArrayDeque<Boolean>();
    private final Deque<Boolean> methodContainsAssertjAssertAll = new ArrayDeque<Boolean>();
    private final Deque<Boolean> inUnitTest = new ArrayDeque<Boolean>();
    private final Deque<ChainedMethods> chainedTo = new ArrayDeque<ChainedMethods>();
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitMethod(MethodTree methodTree) {
        if (ModifiersUtils.hasModifier((ModifiersTree)methodTree.modifiers(), (Modifier)Modifier.ABSTRACT)) {
            return;
        }
        boolean isUnitTest = AssertionsInTestsCheck.isUnitTest(methodTree);
        this.inUnitTest.push(isUnitTest);
        this.methodContainsAssertion.push(false);
        this.methodContainsAssertjSoftAssertionUsage.push(false);
        this.methodContainsAssertjAssertAll.push(false);
        this.methodContainsJunitSoftAssertionUsage.push(false);
        super.visitMethod(methodTree);
        this.inUnitTest.pop();
        Boolean containsAssertion = this.methodContainsAssertion.pop();
        Boolean containsSoftAssertionDecl = this.methodContainsAssertjSoftAssertionUsage.pop();
        Boolean containsAssertjAssertAll = this.methodContainsAssertjAssertAll.pop();
        Boolean containsJunitSoftAssertionUsage = this.methodContainsJunitSoftAssertionUsage.pop();
        if (isUnitTest && !AssertionsInTestsCheck.expectAssertion(methodTree) && (!containsAssertion.booleanValue() || AssertionsInTestsCheck.badSoftAssertionUsage(containsSoftAssertionDecl, containsAssertjAssertAll, containsJunitSoftAssertionUsage))) {
            this.context.reportIssue((JavaCheck)this, (Tree)methodTree.simpleName(), "Add at least one assertion to this test case.");
        }
    }

    private static boolean expectAssertion(MethodTree methodTree) {
        List annotationValues = methodTree.symbol().metadata().valuesForAnnotation("org.junit.Test");
        if (annotationValues != null) {
            for (SymbolMetadata.AnnotationValue annotationValue : annotationValues) {
                if (!"expected".equals(annotationValue.name())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean badSoftAssertionUsage(Boolean containsSoftAssertionDecl, Boolean containsAssertjAssertAll, Boolean containsJunitSoftAssertionUsage) {
        return containsSoftAssertionDecl != false && containsJunitSoftAssertionUsage == false && containsAssertjAssertAll == false;
    }

    public void visitMethodInvocation(MethodInvocationTree mit) {
        if (!this.inUnitTest()) {
            return;
        }
        this.checkForAssertjSoftAssertions(mit);
        if (this.methodContainsAssertion.peek().booleanValue()) {
            return;
        }
        this.chainedTo.push(ChainedMethods.NONE);
        super.visitMethodInvocation(mit);
        ChainedMethods chainedToResult = this.chainedTo.pop();
        if (AssertionsInTestsCheck.containsAssertion(mit, chainedToResult)) {
            this.methodContainsAssertion.pop();
            this.methodContainsAssertion.push(Boolean.TRUE);
        }
        if (!this.chainedTo.isEmpty()) {
            if (ChainedMethods.ASSERT_THAT.equals((Object)chainedToResult) || ASSERT_THAT.matches(mit)) {
                this.chainedTo.pop();
                this.chainedTo.push(ChainedMethods.ASSERT_THAT);
            } else if (MOCKITO_VERIFY.matches(mit)) {
                this.chainedTo.pop();
                this.chainedTo.push(ChainedMethods.MOCKITO_VERIFY);
            }
        }
    }

    public void visitIdentifier(IdentifierTree tree) {
        Symbol symbol;
        Type type;
        if (this.inUnitTest() && (type = (symbol = tree.symbol()).type()) != null && type.isSubtypeOf("org.assertj.core.api.AbstractStandardSoftAssertions")) {
            AssertionsInTestsCheck.setTrue(this.methodContainsAssertjSoftAssertionUsage);
            if (symbol.metadata().isAnnotatedWith("org.junit.Rule")) {
                AssertionsInTestsCheck.setTrue(this.methodContainsJunitSoftAssertionUsage);
            }
        }
        super.visitIdentifier(tree);
    }

    private boolean inUnitTest() {
        return !this.inUnitTest.isEmpty() && this.inUnitTest.peek() != false;
    }

    private static void setTrue(Deque<Boolean> collection) {
        if (!collection.peek().booleanValue()) {
            collection.pop();
            collection.push(true);
        }
    }

    private void checkForAssertjSoftAssertions(MethodInvocationTree mit) {
        if (ASSERTJ_ASSERT_ALL.matches(mit)) {
            AssertionsInTestsCheck.setTrue(this.methodContainsAssertjAssertAll);
        }
    }

    private static boolean containsAssertion(MethodInvocationTree mit, ChainedMethods chainedToResult) {
        boolean isChainedToAssertThatWithBadResolution = ChainedMethods.ASSERT_THAT.equals((Object)chainedToResult) && mit.symbol().isUnknown();
        boolean isChainedToVerify = ChainedMethods.MOCKITO_VERIFY.equals((Object)chainedToResult);
        return isChainedToVerify || isChainedToAssertThatWithBadResolution || AssertionsInTestsCheck.isAssertion(mit);
    }

    private static boolean isAssertion(MethodInvocationTree mit) {
        return ASSERTION_INVOCATION_MATCHERS.anyMatch(mit) && !FEST_AS_METHOD.matches(mit) && !FEST_OVERRIDE_ERROR_METHOD.matches(mit) && !FEST_DESCRIBED_AS_METHOD.matches(mit);
    }

    private static boolean isUnitTest(MethodTree methodTree) {
        for (JavaSymbol.MethodJavaSymbol symbol = (JavaSymbol.MethodJavaSymbol)methodTree.symbol(); symbol != null; symbol = symbol.overriddenSymbol()) {
            if (!symbol.metadata().isAnnotatedWith("org.junit.Test")) continue;
            return true;
        }
        Symbol.TypeSymbol enclosingClass = methodTree.symbol().enclosingClass();
        return enclosingClass != null && enclosingClass.type().isSubtypeOf("junit.framework.TestCase") && methodTree.simpleName().name().startsWith("test");
    }

    private static final MethodMatcher methodWithoutParameter(String typeDefinition, String name) {
        return AssertionsInTestsCheck.methodWithoutParameter(TypeCriteria.is((String)typeDefinition), NameCriteria.is((String)name));
    }

    private static final MethodMatcher methodWithoutParameter(String typeDefinition, NameCriteria methodNameCriteria) {
        return AssertionsInTestsCheck.methodWithoutParameter(TypeCriteria.is((String)typeDefinition), methodNameCriteria);
    }

    private static final MethodMatcher methodWithoutParameter(TypeCriteria typeDefinitionCriteria, String methodName) {
        return AssertionsInTestsCheck.methodWithoutParameter(typeDefinitionCriteria, NameCriteria.is((String)methodName));
    }

    private static final MethodMatcher methodWithoutParameter(TypeCriteria typeDefinitionCriteria, NameCriteria nameCriteria) {
        return MethodMatcher.create().typeDefinition(typeDefinitionCriteria).name(nameCriteria).withNoParameterConstraint();
    }

    private static final MethodMatcher methodWithParameters(String typeDefinition, String methodName) {
        return AssertionsInTestsCheck.methodWithParameters(TypeCriteria.is((String)typeDefinition), methodName);
    }

    private static final MethodMatcher methodWithParameters(TypeCriteria typeDefinitionCriteria, String methodName) {
        return MethodMatcher.create().typeDefinition(typeDefinitionCriteria).name(methodName);
    }

    private static enum ChainedMethods {
        NONE,
        ASSERT_THAT,
        MOCKITO_VERIFY;

    }
}

