/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1166")
public class CatchUsesExceptionWithContextCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String EXCLUDED_EXCEPTION_TYPE = "java.lang.InterruptedException, java.lang.NumberFormatException, java.text.ParseException, java.net.MalformedURLException";
    @RuleProperty(key="exceptions", description="List of exceptions which should not be checked", defaultValue="java.lang.InterruptedException, java.lang.NumberFormatException, java.text.ParseException, java.net.MalformedURLException")
    public String exceptionsCommaSeparated = "java.lang.InterruptedException, java.lang.NumberFormatException, java.text.ParseException, java.net.MalformedURLException";
    private JavaFileScannerContext context;
    private Deque<Collection<IdentifierTree>> validUsagesStack;
    private Iterable<String> exceptions;
    private List<String> exceptionIdentifiers;
    private SemanticModel semanticModel;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.validUsagesStack = new ArrayDeque<Collection<IdentifierTree>>();
        this.exceptions = Splitter.on((String)",").trimResults().split((CharSequence)this.exceptionsCommaSeparated);
        this.exceptionIdentifiers = Lists.newArrayList();
        for (String exception : this.exceptions) {
            this.exceptionIdentifiers.add(exception.substring(exception.lastIndexOf(46) + 1));
        }
        this.semanticModel = (SemanticModel)context.getSemanticModel();
        if (this.semanticModel != null) {
            this.scan((Tree)context.getTree());
        }
    }

    public void visitCatch(CatchTree tree) {
        if (!this.isExcludedType((Tree)tree.parameter().type())) {
            Symbol exception = tree.parameter().symbol();
            this.validUsagesStack.addFirst(Lists.newArrayList((Iterable)exception.usages()));
            super.visitCatch(tree);
            Collection<IdentifierTree> usages = this.validUsagesStack.pop();
            if (usages.isEmpty()) {
                this.context.reportIssue((JavaCheck)this, (Tree)tree.parameter(), "Either log or rethrow this exception.");
            }
        }
    }

    public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
        IdentifierTree identifier = null;
        ExpressionTree expression = tree.expression();
        if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            identifier = (IdentifierTree)expression;
        } else if (expression.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED_EXPRESSION}) && ((ParenthesizedTree)expression).expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            identifier = (IdentifierTree)((ParenthesizedTree)expression).expression();
        }
        if (!this.validUsagesStack.isEmpty() && identifier != null) {
            Iterator<Collection<IdentifierTree>> iterator = this.validUsagesStack.iterator();
            while (iterator.hasNext()) {
                iterator.next().remove(identifier);
            }
        }
        super.visitMemberSelectExpression(tree);
    }

    private boolean isExcludedType(Tree tree) {
        return this.isUnqualifiedExcludedType(tree) || this.isQualifiedExcludedType(tree);
    }

    private boolean isUnqualifiedExcludedType(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && this.exceptionIdentifiers.contains(((IdentifierTree)tree).name());
    }

    private boolean isQualifiedExcludedType(Tree tree) {
        if (!tree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return false;
        }
        return Iterables.contains(this.exceptions, (Object)ExpressionsHelper.concatenate((ExpressionTree)((MemberSelectExpressionTree)tree)));
    }
}

